/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.net.msg.server;

import java.util.ArrayList;
import java.util.ResourceBundle;
import xnap.plugin.nap.net.*;


public class Message {

    public int type;
    protected Server server;
    
    protected Message(int type) {
	this.type = type;
    }
    
    public void setOrigin(Server server) {
	this.server = server;
    }
    
    public Server getServer() {
	return server;
    }
    
    /* [fixme] this is something we don't need since we have a 
       QuotedStringTokenizer already! */
    protected String[] parseData(byte[] b) {
	int i;
	ArrayList list = new ArrayList();
	int length = b.length;
	int offset = 0;
	boolean isQuote = false;
	
	for (i = 0; i < length; i++) {
	    if (b[i] == '"') {
		if (isQuote) {
		    isQuote = false;
		    list.add(new String(b, offset, i - offset));
		    i++;
		    offset = i + 1;
		}
		else {
		    isQuote = true;
		    offset = i + 1;
		}
	    }
	    else if (b[i] == ' ' && !isQuote) {
		if (i - offset > 0) {
		    list.add(new String(b, offset, i - offset));
		}
		offset = i + 1;
	    }
	}
	if (offset != i) {
	    if (isQuote) {
		// Error
	    }
	    list.add(new String(b, offset, i - offset));
	}
	String[] tokens = new String[list.size()];
	list.toArray(tokens);
	return tokens;
    }
	
}


