/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.util.PrivateChannel;
import xnap.util.QuotedStringTokenizer;
import xnap.util.Preferences;

public class PrivateMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 205;

    //--- Data Field(s) ---

    public String nick;
    public String message;

    //--- Constructor(s) ---

    public PrivateMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 2);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	nick = t.nextToken();
	message = t.allNextTokens();
    }

    public void received()
    {
	Preferences prefs = Preferences.getInstance();
	
	if (!message.trim().equals("//WantQueue")) {
	    User user = server.getUser(nick);
	    if (user.isChatIgnored()) {
  		if (prefs.getSendChatIgnoreMessage()) {
		    xnap.plugin.nap.net.msg.client.PrivateMessage msg
			= new xnap.plugin.nap.net.msg.client.PrivateMessage
			    (nick, prefs.getChatIgnoreMessage());
  		    MessageHandler.send(server, msg);
  		}
	    }
	    else {
		PrivateChannel pc 
		    = MessageHandler.createPrivateChannel(user, true);
		pc.messageReceived(message);
	    }
	}
    }
}
