/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.User;
import xnap.util.QuotedStringTokenizer;
import xnap.util.StringHelper;

public class SearchResponseMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 201;

    //--- Data Field(s) ---

    public String filename;
    public String md5;
    public long filesize;
    public int bitrate;
    public int frequency;
    public int length;
    public String nick;
    public String ip;
    public int linkSpeed;
    public int weight;
    public int queuePos;
    public String clientInfo;

    //--- Constructor(s) ---

    public SearchResponseMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 9);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	filename = t.nextToken();
	md5 = t.nextToken();
	filesize = Long.parseLong(t.nextToken());
	bitrate = Integer.parseInt(t.nextToken());
	frequency = Integer.parseInt(t.nextToken());
	length = Integer.parseInt(t.nextToken());
	nick = t.nextToken();
	ip = StringHelper.parseIP(t.nextToken());
	linkSpeed = Integer.parseInt(t.nextToken());

	weight = 0;
	queuePos = -1;
	if (t.countTokens() >= 2) {
	    try {
		// could be set to "n/a"
		queuePos = Integer.parseInt(t.nextToken());
	    }
	    catch (NumberFormatException e) {
	    }
	    clientInfo = t.nextToken();
	}
	else if (t.hasMoreTokens()) {
	    weight = Integer.parseInt(t.nextToken());
	}
    }

    public void received()
    {
	User user = server.getUser(nick);
	user.setIP(ip);
	user.setLinkSpeed(linkSpeed);
	if (clientInfo != null) {
	    user.setClientInfo(clientInfo);
	}
    }

}
