/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.Upload;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.AcceptFailedMessage;
import xnap.plugin.nap.net.msg.client.PrivateMessage;
import xnap.plugin.nap.net.msg.client.QueueLimitMessage;
import xnap.plugin.nap.net.msg.client.UploadAckMessage;
import xnap.plugin.nap.util.NapFileHelper;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.QuotedStringTokenizer;
import xnap.util.UploadQueue;
import xnap.util.FileHelper;
import xnap.util.StringHelper;
import xnap.io.Repository;

import java.io.*;

import org.apache.log4j.Logger;

public class UploadRequestMessage extends ServerMessage{

    //--- Constant(s) ---

    public static final int TYPE = 607;

    //--- Data Field(s) ---

    public String nick;
    public String filename;
    public int linkSpeed;

    private static Logger logger = 
	Logger.getLogger(UploadRequestMessage.class);

    //--- Constructor(s) ---

    public UploadRequestMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 2);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	nick = t.nextToken();
	filename = t.nextToken();
  	if (t.hasMoreTokens()) {
  	    linkSpeed = Integer.parseInt(t.nextToken());
  	}
    }

    public void received() 
    {
	if (NapPreferences.getInstance().getWhoisQueryOnTransfer()) {
	    server.getUser(nick).update(true);
	}

	File file = NapFileHelper.getRepositoryFile(filename);
	Upload u = new Upload(nick, file, server, filename);
	
//  	if (file == null || !server.getUser(nick).isAllowedToDownload()) {
//  	    logger.warn("rejecting leecher / invalid request: " + nick + " "
//  			+ filename);
//  	    u.reject();
//  	    return;

	if (file == null) {
  	    logger.warn("invalid request: " + nick + " " + filename);
  	    u.reject();
  	    return;
	}
	
	if (!server.getUser(nick).isAllowedToDownload()) {
  	    logger.warn("rejecting leecher" + nick + " " + filename);
  	    u.reject();
  	    return;
	}
	
	UploadQueue uq = UploadQueue.getInstance();
	logger.debug("upload: " + nick + " " + filename);

	boolean added = uq.add(u);
	if (added) {
	    // give the download queue a chance to start the download 
	    // right away to avoid sending local queued responses
	    try {
		Thread.currentThread().sleep(20);
	    }
	    catch (InterruptedException e) {
	    }
	}

	int pos = uq.getLocalQueuePos(u);
	if (pos == -1 && !added) {
	    if (uq.isRunning(u)) {
		// some clients need two confirmations before they start
		// downloading
		MessageHandler.send
		    (server, new UploadAckMessage(nick, filename));
	    }
	    else {
		logger.warn("upload queue rejected " + filename);
		u.reject();
	    }
	}
	else if (pos != -1) {
	    // pos == 0 means busy, so we always send pos > 0
	    QueueLimitMessage m = new QueueLimitMessage(nick, filename,
							pos + 1);
	    MessageHandler.send(server, m);
	}
    }

}
