/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.util;

import xnap.io.Repository;
import xnap.util.FileHelper;
import xnap.util.Preferences;
import xnap.util.StringHelper;

import java.io.*;
import java.util.*;


public class NapFileHelper
{


    //--- Constant(s) ---

    //--- Data field(s) ---

    //--- Constructor(s) ---

    //--- Method(s) ---
    

    /**
     * Converts the system-dependent pathname to the napsterized form 
     * which uses '\' as separator.
     */
    public static String getShareString(int index, File file) 
    {
	if (Preferences.getInstance().getShareFullPath()){
	    return file.getAbsolutePath().replace(file.separatorChar, '\\');
	}
	else {
	    return index + "\\" + file.getName();
	}
    }

    

    /**
     * Extracts index and filename from napster specific shared filename and
     * return file if it's a valid Repository entry.
     *
     * @return null, if filename is not part of repository
     */
    public static File getRepositoryFileByIndex(String filename) 
    {
	StringTokenizer st = new StringTokenizer(filename, "\\");

	if (st.countTokens() >= 2) {
	    try {
		int index = Integer.parseInt(st.nextToken());
		String file = st.nextToken("").substring(1);

		return Repository.getInstance().getRepositoryFile(file, index);
	    }
	    catch (NumberFormatException e) {
	    }
	}

	return null;
    }

    /**
     * Retrieves repository file.
     * First we try to retrieve the file by parsing for its repository index,
     * if this does not work, we'll try to search for the file.
     */
    public static File getRepositoryFile(String filename)
    {
	File file = getRepositoryFileByIndex(filename);
	if (file != null) {
	    return file;
	}

	String shortname = FileHelper.extension(filename, "\\");
	File[] results = Repository.getInstance().search(shortname);

	filename = filename.replace('\\', File.separatorChar);
	if (results != null) {
	    for (int i = 0; i < results.length; i++) {
		if (results[i].getAbsolutePath().equals(filename)) {
		    return results[i];
		}
	    }
	}
    
	return null;
    }

}
