/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.util;

import xnap.plugin.nap.net.Server;
import xnap.util.PortRange;
import xnap.util.QuotedStringTokenizer;

import java.io.*;
import java.util.*;

public class ServerFile {

    //--- Data Field(s) ---

    private BufferedReader in = null;
    private BufferedWriter out = null;
    private String filename;

    //--- Constructor(s) ---
	
    public ServerFile(String filename)
    {
	this.filename = filename;
    }

    //--- Method(s) ---

    public void close()
    {
	try {
	    if (in != null) {
		in.close();
	    }
	    if (out != null) {
		out.close();
	    }
	}	    
	catch (IOException e) {
	}
    }

    public String getFilename()
    {
	return filename;
    }
    
    public BufferedReader getIn()
    {
	return in;
    }

    public BufferedWriter getOut()
    {
	return out;
    }

    public void openReader() throws IOException
    {
	in = new BufferedReader(new FileReader(getFilename()));
    }

    public void openWriter() throws IOException
    {
	out = new BufferedWriter(new FileWriter(getFilename(), false));
    }

    public Server readServer() throws IOException {
	String line;

	while ((line = getIn().readLine()) != null) {
	    try {
		QuotedStringTokenizer t 
		    = new QuotedStringTokenizer(line, " :");
		
		if (t.countTokens() < 2) {
		    continue;
		}
		    
		String ip = t.nextToken();
		int port = Integer.parseInt(t.nextToken());
		if (port < PortRange.MIN_PORT || port > PortRange.MAX_PORT) {
		    throw new NumberFormatException();
		}

				String network = (t.countTokens() > 0) ? t.nextToken() : "";

				Server s = new Server(ip, port, network);

				if (t.countTokens() >= 3) {
					String token = t.nextToken();
					s.setUsername((token.length() > 0) ? token : null);
					token = t.nextToken();
					s.setPassword((token.length() > 0) ? token : null);
					token = t.nextToken();
					s.setEmail((token.length() > 0) ? token : null);
				}
					
				if (t.countTokens() >= 1) {
					s.setRedirector(t.nextToken().equals("true"));
				}
					
				if (t.countTokens() >= 1) {
					t.nextToken(); //s.setAutoJoinChannels();
				}

		return s;
	    } 
	    catch (NumberFormatException e) {
	    }
	}

        return null;
    }

    public void writeServer(Server s) throws IOException
    {
		StringBuffer sb = new StringBuffer();
		append(sb, s.getHost());
		append(sb, s.getPort() + "");
		append(sb, s.getNetwork());
		append(sb, (s.isLoginCustomized()) ? s.getUsername() : "");
		append(sb, (s.isLoginCustomized()) ? s.getPassword() : "");
		append(sb, (s.isLoginCustomized()) ? s.getEmail() : "");
		append(sb, (s.isRedirector()) ? "true" : "false");
		append(sb, ""); //s.getAutoJoinChannels()
				  
		out.write(sb.toString());
		out.newLine();
	}

	private static void append(StringBuffer sb, String s)
	{
		sb.append("\"");
		sb.append(s);
		sb.append("\" ");
	}

}

