/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.util;

import xnap.plugin.nap.net.Server;
import xnap.util.Debug;

import java.io.*;
import java.util.*;

public class TrippyMXFile extends ServerFile {

    //--- Data Field(s) ---

    private FileInputStream in;
    private int pos;

    //--- Constructor(s) ---
	
    public TrippyMXFile(String filename)
    {
	super(filename);
    }
    
    //--- Method(s) ---

    public void openReader() throws IOException
    {
	in = new FileInputStream(getFilename());
    }

    public void openWriter() throws IOException
    {
	throw new IOException("Write not supported");
    }

    public Server readServer() throws IOException 
    {
	while (true) {
	    search("OPENNAP041");
	    
	    String username = readString();
	    String password = readString();
	    String email = readString();
	    String client = readString();
	    
	    String ip = "";
	    while (ip.length() == 0) {
		ip = readString();
	    }
	    
	    // FIX: need to find out more about the format
	    if (ip.startsWith("*")) {
		continue;
	    }

	    // little endian
	    int port = readNumber16();
	    
	    Server s = new Server(ip, port/*, network*/);
	    
	    if (!username.equals("XXXX")) {
		s.setUsername(username);
		s.setPassword(password);
		s.setEmail(email);
	    }
	    
	    return s;
	}
    }

    public void writeServer(Server s) throws IOException
    {
	throw new IOException("Write not supported");
    }

    private String readString() throws IOException
    {
	int length = in.read();
	if (length == 0) {
	    return "";
	}
	else if (length != -1) {
	    Debug.log("length: " + length);
	    byte[] data = new byte[length];
	    int read = in.read(data);
	    if (read == length) {
		String s = new String(data);
		Debug.log("read: " + s);
		return s;
	    }
	}

	throw new IOException("File is corrupt.");
    }

    private int readNumber16() throws IOException
    {
	int lo = in.read();
	int hi = in.read();
	if (lo != -1 && hi != -1) {
	    Debug.log("read 16-bit number: " + (hi * 256 + lo));
	    return hi * 256 + lo;
	}

	throw new IOException("File is corrupt.");	
    }

    private void search(String needle) throws IOException
    {
	int b;
	int pos = 0;
	while ((b = in.read()) != -1) {
	    if ((char)b == needle.charAt(pos)) {
		pos++;
	    }
	    else {
		pos = 0;
	    }

	    if (pos == needle.length()) {
		return;
	    }
	}

	throw new IOException("File is corrupt.");
    }
}
