/*
 * 04/29/2003
 * 
 * This file is now part of XNap, but is based on:
 *
 * WSXServerlistReader.java
 * Copyright (C) 2003 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.nap.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import xnap.plugin.nap.net.Server;


public class WSXServerFile {
	private static final String NETWORK = "N";
	private static final String PORT = "P";
	private static final String ADDRESS = "A";
	private static final String TYPE = "T";
	private static final String AUTO_CONNECT = "AC";
	private static final String USERNAME = "UN";
	private static final String USER_PASSWORD = "UP";
	private static final String NAME_VALUE_DELIM = ": ";
	private static final String NOT_AVAILABLE = "N/A";
	private static final String TYPE_NORMAL = "NORMAL";
	private static final String TYPE_META = "META";
	private static final int DEFAULT_NORMAL_PORT = 8888;
	private static final int DEFAULT_META_PORT = 8875;

	public static void writeServerlist( File serverlistFile, Server[] servers)
		throws IOException {

		BufferedWriter out =
			new BufferedWriter(new FileWriter(serverlistFile));

		try {
			for (int i = 0; i < servers.length; i++) {
				String host = servers[i].getHost();
				if (host == null) {
					host = "";
				}
				String network = servers[i].getNetwork();
				if (network == null) {
					network = NOT_AVAILABLE;
				}
				out.write(NETWORK);
				out.write(NAME_VALUE_DELIM);
				out.write(network);
				out.newLine();
				out.write(TYPE);
				out.write(NAME_VALUE_DELIM);
				out.write(
					servers[i].isRedirector() ? TYPE_META : TYPE_NORMAL);
				out.newLine();
				out.write(PORT);
				out.write(NAME_VALUE_DELIM);
				out.write(Integer.toString(servers[i].getPort()));
				out.newLine();
				out.write(AUTO_CONNECT);
				out.write(NAME_VALUE_DELIM);
				out.write("false");
				out.newLine();
				if (servers[i].getUsername() != null) {
					out.write(USERNAME);
					out.write(NAME_VALUE_DELIM);
					out.write(servers[i].getUsername());
					out.newLine();
				}
				if (servers[i].getPassword() != null) {
					out.write(USER_PASSWORD);
					out.write(NAME_VALUE_DELIM);
					out.write(servers[i].getPassword());
					out.newLine();
				}
				out.write(ADDRESS);
				out.write(NAME_VALUE_DELIM);
				out.write(host);
				out.newLine();
			}

			out.flush();
		} finally {
			out.close();
		}
	}

	public static Server[] readServerlist(File serverlistFile)
			throws IOException {
		ArrayList serverList = new ArrayList();
		BufferedReader in;
		String line;
		String network = null;
		String address = null;
		int port = -1;
		String type = null;
		String username = null;
		String password = null;

		try {
			in = new BufferedReader(new FileReader(serverlistFile));
		} catch (FileNotFoundException e) {
			return new Server[] {
			};
		}

		try {
			while ((line = in.readLine()) != null) 
				{
				if (line.length() > 0 && line.charAt(0) != '#') 
					{
					int i = line.indexOf(':');
					if (i > 0) 
						{
						String valueName = line.substring(0, i);
						String value = line.substring(i + 1).trim();
						if (valueName.equals(NETWORK)) {
							if (!value.equalsIgnoreCase(NOT_AVAILABLE)
									&& value.length() > 0) 
								{
									network = value;
								}
						} else if (valueName.equals(ADDRESS)) 
							{
								if (value.length() > 0) {
									address = value;
							}
							addServer(network, address,	port, type, username,
									  password, serverList);

							address = null;
							port = -1;
							username = null;
							password = null;

							} else if (valueName.equals(PORT)) {
								try {
									port = Integer.parseInt(value);
								} catch (NumberFormatException e) {
								}
							} else if (valueName.equals(TYPE)) {
							type = value;
							} else if (valueName.equals(USERNAME)) {
								username = value;
							} else if (valueName.equals(USER_PASSWORD)) {
								password = value;
							}
						}
					}
				}
		} finally {
			in.close();
		}
		
		Server[] servers =
			new Server[serverList.size()];
		return (Server[]) serverList.toArray(servers);
	}

	private static void addServer(String network, String address, int port,
								  String type, String username,	
								  String password, ArrayList serverList) 
		{
			if (port == -1) {
				int index = address.lastIndexOf(':');
				if (index != -1) {
					try {
						port = Integer.parseInt(address.substring(index + 1));
						address = address.substring(0, index);
					} catch (NumberFormatException e) {
					}
				}
			}
			if (port == -1) {
				if (type != null && type.equals(TYPE_META)) {
					port = DEFAULT_META_PORT;
				} else {
					port = DEFAULT_NORMAL_PORT;
				}
			}
			
			Server server = null;
			
			if (address != null && port > 0) {
				server = new Server(address, port);
				if (network != null) {
					server.setNetwork(network);
				}
			} else if (network != null) {
				server = new Server();
				server.setNetwork(network);
			}
			
			if (server != null) {
				if (type != null && type.equals(TYPE_META)) {
					server.setRedirector(true);
				}
				serverList.add(server);
			}
		}
}






