/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.net.*;

import java.util.*;

public class Grouper
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected EventVector data;
    protected Hashtable groups = new Hashtable();

    //--- Constructor(s) ---

    public Grouper()
    {
    }

    //--- Method(s) ---

    public void clear()
    {
	data.clear();
	groups.clear();
    }

    public void setData(EventVector newValue)
    {
	data = newValue;
    }

    /**
     * Sub classes should overwrite this. Wraps a 
     * <code>SearchResultGroup<code> around <code>sr</code> and adds to 
     * <code>data</code>.
     */
    public void add(ISearchResult sr)
    {
	data.add(new SearchResultContainer(sr));
    }

    protected void addToGroup(Object hash, ISearchResult sr)
    {
	if (sr.canGroup()) {
	    SearchResultContainer value 
		= (SearchResultContainer)groups.get(hash);
	    
	    if (value == null) {
		SearchResultContainer c = new SearchResultContainer(sr);
		groups.put(hash, c);
		data.add(c);
	    }
	    else {
		((SearchResultContainer)value).add(sr);
	    }
	}
	else {
	    SearchResultContainer c = new SearchResultContainer(sr);
	    data.add(c);
	}
    }

}
