/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.util;

import xnap.net.ISearch;
import xnap.util.event.StatusListener;

public interface ISearchContainer {

    // --- Constants(s) ---

    // --- Method(s) ---

    /**
     * Aborts this search. Search can not be restarted.
     */
    void abort();

    /**
     * Returns the collector for this search.
     */
    SearchResultCollector getCollector();

    void setCollector(SearchResultCollector c);

    Grouper getDefaultGrouper();

    /**
     * Returns the filter that was used for this search. This is used
     * by auto downloads for researching.
     */
    SearchFilter getFilter();

    String getStatus();

    /**
     * Adds a status listener.
     *
     * @param l should be notified when status changes
     */
    void setStatusListener(StatusListener l);

    /**
     * Starts this search. Only called once.
     */
    void start();

}
