/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.util.prefs.Validator;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.apache.log4j.Logger;

/**
 * Wraps preferences for plugins. 
 */
public abstract class PluginPreferencesSupport 
    implements TablePreferencesSupport {

    //--- Constant(s) ---

    public static final String ARRAY_SEPARATOR = ";";
    public static final String VERSION_KEY = "props.ver";

    //--- Data field(s) ---

    protected static Logger logger 
	= Logger.getLogger(PluginPreferencesSupport.class);

    protected Preferences prefs = Preferences.getInstance();

    private String namespace = "";
    private int version;

    //--- Constructor(s) ---
    
    protected PluginPreferencesSupport(String namespace, int version)
    {
	if (!namespace.endsWith(".")) {
	    namespace += ".";
	}
				       
	this.namespace = namespace;
	this.version = version;

	int oldVersion = getInt(VERSION_KEY);
	if (oldVersion < version) {
	    logger.debug("converting from version " + oldVersion + " to " 
			 + version);
	    convert(oldVersion);
	}
	set(VERSION_KEY, version);
    }

    protected PluginPreferencesSupport(String namespace)
    {
	this(namespace, 0);
    }

    //--- Method(s) ---

    public synchronized	
	void addPropertyChangeListener(PropertyChangeListener l)
    {
	prefs.addPropertyChangeListener(l);
    }

    public synchronized	
	void addPropertyChangeListener(String prop, PropertyChangeListener l)
    {
	prefs.addPropertyChangeListener(prop, l);
    }

    public synchronized 
	void addTableListener(String table, PropertyChangeListener l)
    {
	prefs.addTableListener(table, l);
    }
       
    public synchronized
	void removePropertyChangeListener(PropertyChangeListener l) {
        prefs.removePropertyChangeListener(l);
    }

    /**
     * Sub classes should overwrite this.
     */
    public void convert(int oldVersion)
    {
    }

    public String get(String key)
    {
	return prefs.get(namespace + key);
    }

    public boolean getBoolean(String key)
    {
	return prefs.getBoolean(namespace + key);
    }

    public int getInt(String key)
    {
	return prefs.getInt(namespace + key);
    }

    public long getLong(String key)
    {
	return prefs.getLong(namespace + key);
    }

    public int[] getTableColumnsArray(String table)
    {
	return prefs.getTableColumnsArray(namespace + table);
    }

    public int[] getTableColumnWidths(String table)
    {
	return prefs.getTableColumnWidths(namespace + table);
    }

    public boolean getTableMaintainSortOrder(String table)
    {
	return prefs.getTableMaintainSortOrder(namespace + table);
    }

    public int getTableSortedColumn(String table) 
    {
	return prefs.getTableSortedColumn(namespace + table);
    }

    public void removeProperty(String key)
    {
	prefs.removeProperty(key);
    }

    /**
     * Renames a property, used for conversion of property file formats.
     * Ignores namespace. Does not fire change event.
     */
    public void renameProperty(String oldKey, String newKey)
    {
	prefs.renameProperty(oldKey, newKey);
    }

    public void set(String key, String newValue)
    {
	prefs.set(namespace + key, newValue);
    }

    public void set(String key, boolean newValue)
    {
	prefs.set(namespace + key, newValue);
    }

    public void set(String key, int newValue)
    {
	prefs.set(namespace + key, newValue);
    }

    public void set(String key, long newValue)
    {
	prefs.set(namespace + key, newValue);
    }

    public void setDefault(String key, String value, Validator validator)
    {
	prefs.setDefault(namespace + key, value, validator);
    }

    public void setDefault(String key, String value)
    {
	prefs.setDefault(namespace + key, value);
    }

    public void setTableColumns(String table, String columns)
    {
	prefs.setTableColumns(namespace + table, columns);
    }

    public void setTableColumns(String table, int[] columns)
    {
	prefs.setTableColumns(namespace + table, columns);
    }

    public void setTableColumnWidths(String table, int[] widths)
    {
	prefs.setTableColumnWidths(namespace + table, widths);
    }

    public void setTableMaintainSortOrder(String table, boolean enable)
    {
	prefs.setTableMaintainSortOrder(namespace + table, enable);
    }

    public void setTableSortedColumn(String table, int column)
    {
	prefs.setTableSortedColumn(namespace + table, column);
    }

}

