/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.util.*;

import java.util.*;

/**
 * Higher priorities are popped first. This class is thread safe.
 */
public class PriorityQueue
{

    //--- Constant(s) ---

    //--- Data field(s) ---
    
    protected LinkedList queue = new LinkedList();

    //--- Constructor(s) ---

    public PriorityQueue()
    {
    }

    //--- Method(s) ---
    
    public synchronized void add(Object o, int priority)
    {
	Element e = new Element(o, priority);
	    
	if (queue.contains(e)) {
	    return;
	}
	    
	boolean inserted = false;
	for (ListIterator i = queue.listIterator(); i.hasNext() && !inserted;) {
	    if (e.priority > ((Element)i.next()).priority) {
		i.previous();
		i.add(e);
		inserted = true;
	    }
	}

	if (!inserted) {
	    queue.add(e);
	}
    }

    public synchronized void clear()
    {
	queue.clear();
    }

    public Object get(int index)
    {
	return ((Element)queue.get(index)).o;
    }

    public synchronized int indexOf(Object o)
    {
	return queue.indexOf(new Element(o));
    }
    
    public synchronized Object peek()
    {
	return ((Element)queue.getFirst()).o;
    }

    public synchronized Object pop()
    {
	//  Debug.log("prio queue: pop");
	    
	if (queue.size() == 0) {
	    return null;
	}
	
	return ((Element)queue.removeFirst()).o;
    }
    
    public synchronized boolean remove(Object o)
    {
	return queue.remove(new Element(o));
    }

    public synchronized int size()
    {
	return queue.size();
    }

    public synchronized Object[] toArray()
    {
	Object[] elements = new Object[queue.size()];
	int i = 0;
	for (Iterator it = queue.iterator(); it.hasNext(); i++) {
	    elements[i] = ((Element)it.next()).o;
	}
	return elements;
    }

    public class Element 
    {
	public Object o;
	public int priority;
	
	public Element(Object o, int priority)
	{
	    this.o = o;
	    this.priority = priority;
	}

	public Element(Object o)
	{
	    this.o = o;
	}

	public boolean equals(Object object)
	{
	    if (object instanceof Element) {
		return o.equals(((Element)object).o);
	    }

	    return false;
	}

    }
}
