/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import java.util.*;

public class VersionParser implements Comparable {
    
    // --- Data Field(s) ---

    private String extra = "";
    private int extraLevel = 0;
    private int major = 0;
    private int minor = 0;
    private String version;

    // --- Constructor(s) ---

    public VersionParser(String version) {
	this.version = version;

	parse();
    }

    // --- Method(s) ---

    public static int compare(String v1, String v2) 
    {
	int result = (new VersionParser(v1)).compareTo(new VersionParser(v2));
	return result;
    }

    public int compareTo(Object o) 
    {
	VersionParser vp = (VersionParser)o;

	if (major > vp.major)
	    return 1;
	else if (major < vp.major)
	    return -1;

	if (minor > vp.minor)
	    return 1;
	else if (minor < vp.minor)
	    return -1;
	   
	int c = compareExtra(vp.extra);
	if (c != 0)
	    return c;

	if (extraLevel > vp.extraLevel)
	    return 1;
	else if (extraLevel < vp.extraLevel)
	    return -1;
	
	return 0;
    }

    public int compareExtra(String extra2) 
    {
	String extra1 = extra;

	if (extra1.equals(extra2))
	    return 0;

	if (extra1.length() == 0)
	    return 1;

	if (extra2.length() == 0)
	    return -1;

	return extra1.compareTo(extra2);
    }

    private void parse() 
    {
	StringTokenizer t = new StringTokenizer(version, ".-_ ");

	try {
	    if (t.hasMoreTokens()) 
		major = Integer.parseInt(t.nextToken());
	    
	    if (t.hasMoreTokens())
		minor = Integer.parseInt(t.nextToken());

	    extra = "";
	    if (t.hasMoreTokens()) {
		String tail = t.nextToken();

		int i = StringHelper.indexOfDigit(tail);
		if (i != -1) { 
		    extra = tail.substring(0, i);
		    extraLevel = Integer.parseInt(tail.substring(i));
		} 
	    }
	} 
	catch (Exception e) {
	}
    }

    public String toString()
    {
	StringBuffer sb = new StringBuffer();
	sb.append(major);
	sb.append(".");
	sb.append(minor);
	if (extra.length() > 0) {
	    sb.append("-");
	    sb.append(extra);
	    sb.append(extraLevel);
	}
	return sb.toString();
    }

}

