/*
   xslideshow.c - displays pictures on the X11 window

   Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

          Copyright 1993-1997 by Susumu Shiohara

                   All Rights Reserved

*/

#include "xslideshow.h"
#include "animate.h"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern ErrStatus checkFileType P_((char *));
extern ErrStatus gif2gimage P_((char *));
extern ErrStatus jpg2gimage P_((char *));
extern ErrStatus CreateXImage P_(());
extern void replaceBiffWindow P_(());
extern void replaceClockWindow P_(());
extern void lg3zoom P_((unsigned int, unsigned int));
extern void zoom24 P_((unsigned int, unsigned int));
extern void zoom P_((unsigned int, unsigned int));
extern void FreeXImage P_(());
extern void makeAppreciationCursor P_(());
extern void makePauseCursor P_(());
extern void makeWaitCursor P_(());

extern ActionStatus xgifanim P_((char *));
extern void postxgifanim P_((char *));

int  doPostAnimate=False;
int originalImageWidth, originalImageHeight;
char currentAnimate[256];
char postAnimate[256];

#if defined(__STDC__) || defined(__cplusplus)
static void fitIt(Widget topWidget, char *fname)
#else
static void fitIt(topWidget, fname)
Widget topWidget;
char *fname;
#endif
{
Arg args[5];
int ac;
int d_h,f_a,f_d;
XCharStruct overall;
int ww, wh, dw, dh, xzoom, yzoom;
double dzoom;


	/* Set the window size */
	if(!app_data.root && !app_data.full && !app_data.resize){

		/* Change the window size according to StructureNotify Event */
		if( windowWidth != newWindowWidth
			|| windowHeight != newWindowHeight){

			windowWidth = newWindowWidth;
			windowHeight = newWindowHeight;

			replaceBiffWindow();
			replaceClockWindow();
		}

	} else if(!app_data.root && !app_data.full && app_data.resize){

		/* Change the window size to the picture size */
		windowWidth = gim.subImageList->width;
		windowHeight = gim.subImageList->height;

		if( app_data.showFileName || app_data.clock ){
			/* Get text and font information */
			XTextExtents(
				app_data.font,
				fname,strlen(fname),
				&d_h,&f_a,&f_d,&overall
				);

			/* Expand window size to show file name and clock */
			windowHeight = windowHeight + (overall.descent + overall.ascent) * 2;
		}

		/* Set and change window size */
		ac = 0;
		XtSetArg(args[ac],XtNwidth,windowWidth);ac++;
		XtSetArg(args[ac],XtNheight,windowHeight);ac++;
		XtSetValues(topWidget,args,ac);

		replaceBiffWindow();
		replaceClockWindow();
	}


	/* Check if it is need to zoom an image */
	if(!app_data.resize && (app_data.fit || app_data.maxfit)){

		if(!strcmp(app_data.animate,"float24")){
			ww = app_data.floatImageSize;
			wh = app_data.floatImageSize;
		}
		else {
			ww = windowWidth;
			wh = windowHeight;

			if( app_data.showFileName || app_data.clock ){
				/* Get the text and font information */
				XTextExtents(app_data.font,fname,strlen(fname),
					&d_h,&f_a,&f_d,&overall);

				/* Make space for showing the file name and the clock */
				wh = wh - (overall.descent + overall.ascent)*2;
			}
		}


		/* Calculate zoom size */
		if(ww < gim.subImageList->width && wh < gim.subImageList->height) {

			dw = gim.subImageList->width - ww;
			dh = gim.subImageList->height - wh;

			if(dw > dh){
				xzoom = (int)((double)ww * 100 / gim.subImageList->width);
				if((gim.subImageList->height * xzoom) > (wh * 100)){
					dzoom = (double)wh * 100 / (gim.subImageList->height * xzoom);
					yzoom = (int)((double)xzoom * dzoom);
					xzoom = yzoom;
				}
				else{
					yzoom = xzoom;
				}
			}
			else {
				yzoom = (int)((double)wh * 100 / gim.subImageList->height);
				xzoom = yzoom;
			}

		}
		else if(ww < gim.subImageList->width && wh >= gim.subImageList->height) {

			xzoom = (int)((double)ww * 100 / gim.subImageList->width);
			yzoom = xzoom;

		}
		else if(ww >= gim.subImageList->width && wh < gim.subImageList->height) {

			yzoom = (int)((double)wh * 100 / gim.subImageList->height);
			xzoom = yzoom;

		}
		else if(ww >= gim.subImageList->width && wh >= gim.subImageList->height) {

			if( app_data.maxfit){
				yzoom = (int)((double)wh * 100 / gim.subImageList->height);
				xzoom = yzoom;
			}
			else{
				xzoom = yzoom = 100;
			}

		}

		if(xzoom < 100 || xzoom > 100) {
			if(!strcmp(app_data.zoom,"fast")){
				if(gim.subImageList->bits_per_pixel == 24)
					zoom24(xzoom, yzoom);
				else
					zoom(xzoom, yzoom);
			}
			else{
				lg3zoom(xzoom, yzoom);
			}
		}
	}
}

#if defined(__STDC__) || defined(__cplusplus)
ErrStatus animateShow(Widget topWidget,char *fname,int *hasImage, int *action)
#else
ErrStatus animateShow(topWidget,fname,hasImage,action)
Widget topWidget;
char *fname;
int *hasImage;
int *action;
#endif
{
ErrStatus errf=ERR_NO_ERR;
SUBGIMAGE *prev,*cur,*next;

	*hasImage = True;

	strcpy(currentAnimate,app_data.animate);

	if(!app_data.root)
		makeWaitCursor();

	/* Check file type (GIF or JPEG or .. ) */
	if((errf = checkFileType(fname)) != ERR_NO_ERR) {

		if(!app_data.root)
			makeAppreciationCursor();

		*hasImage = False;
		return(errf);
	}


	if(fileType == IS_GIF){

		/* Convert GIF file to General Image Format (GIMAGE) */
		if((errf = gif2gimage(fname)) != ERR_NO_ERR) {
			if(gim.subImageList->image != (byte *)NULL) {
				XtFree((char *)(gim.subImageList->image));
				gim.subImageList->image = (byte *)NULL;
			}
			if(!app_data.root)
				makeAppreciationCursor();

			*hasImage = False;
			return(errf);
		}

	}
	else if(fileType == IS_JPG){

		/* Convert JPEG file to General Image Format (GIMAGE) */
		if((errf = jpg2gimage(fname)) != ERR_NO_ERR) {
			if(gim.subImageList->image != (byte *)NULL) {
				XtFree((char *)(gim.subImageList->image));
				gim.subImageList->image = (byte *)NULL;
			}
			if(!app_data.root)
				makeAppreciationCursor();

			*hasImage = False;
			return(errf);
		}

	}
	else {
		if(!app_data.root)
			makeAppreciationCursor();

		*hasImage = False;
		return(ERR_NO_ERR);
	}


	/* Check if there are valid subimages */
	prev = gim.subImageList;
	do {
		cur = prev->next;
		if(cur == (SUBGIMAGE *)NULL)
			break;
		if(cur->image == (byte *)NULL
				|| cur->width == 0
				|| cur->height == 0){
			if(cur->image != (byte *)NULL){
				XtFree((char *)cur->image);
				cur->image = (byte *)NULL;
			}
			next = cur->next;
			XtFree((char *)cur);
			prev->next = next;
			prev = next;
		}
		else {
			prev = cur;
		}
	} while (prev != (SUBGIMAGE *)NULL);


	/* Check if there is a valid image */
	if(gim.subImageList->image == (byte *)NULL
			|| gim.subImageList->width == 0
			|| gim.subImageList->height == 0){

		if(gim.subImageList->image != (byte *)NULL){
			XtFree((char *)gim.subImageList->image);
			gim.subImageList->image = (byte *)NULL;
		}
		/* Image was not created */
		if(!app_data.root)
			makeAppreciationCursor();

		*hasImage = False;
		return(ERR_NO_ERR);
	}

	/* Let's do animate ! */
  	if(gim.subImageList->next != (SUBGIMAGE *)NULL)
		strcpy(currentAnimate,"gifanim");

	gotSomeAction = False;

	do {

		originalImageWidth = gim.subImageList->width;
		originalImageHeight = gim.subImageList->height;

		/* Resize if need */
		fitIt(topWidget, fname);

		/*
		The CreateXImage routine frees its pixels,
		so must do postAnimateFunc before calling CreateXImage
		*/
		if(doPostAnimate) {
			(void)postAnimateFunc[animate_strtoenum(postAnimate)](fname);
		}

		/* Create the XImage */
		if((errf = CreateXImage()) != ERR_NO_ERR) {  
			/* Some error happend */
			if(gim.subImageList->image != (byte *)NULL) {
				XtFree((char *)(gim.subImageList->image));
				gim.subImageList->image = (byte *)NULL;
			}
			if(!app_data.root)
				makeAppreciationCursor();

			*hasImage = False;
			return(errf);
		}

		if(!app_data.root)
			makeAppreciationCursor();

		*action = animateFunc[animate_strtoenum(currentAnimate)](fname);

		strcpy(postAnimate,currentAnimate);
		doPostAnimate = True;

		FreeXImage();

		if(gotSomeAction){
			while(gim.subImageList->next != (SUBGIMAGE *)NULL){
				cur = gim.subImageList;
				gim.subImageList = gim.subImageList->next;
				if(cur->image != (byte *)NULL){
					XtFree((char *)cur->image);
				}
				XtFree((char *)cur);
			} 
			if(gim.subImageList->image != (byte *)NULL){
				XtFree((char *)gim.subImageList->image);
				gim.subImageList->image = (byte *)NULL;
			}
			break;
		}

		if(gim.subImageList->next == (SUBGIMAGE *)NULL){
			break;
		}
		else { /* link next subimage */
			cur = gim.subImageList;
			gim.subImageList = gim.subImageList->next;
			XtFree((char *)cur);
		}

	} while(True);

	/* End displaying all images */
	return(errf);
}

