/*
 * ppm2qt.c
 * just a dirty hack!
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include "gt.h"

/*
 */
static void
usage (char *progname)
{
	printf (
		"Usage: %s "
		"[-v] "
		"[-t #] "
		"[-j] "
		"[-s #x#] "
		"-o <output> <input-files ..>\n", progname);
	exit (1);
}

/*
 * read ppm header of a rawbits ppm file (P6)
 */
int
read_ppm_header (FILE *fp, int *width, int *height)
{
	char buff[128];

	*width = *height = 0;
	while (*width == 0) {
		fgets (buff, 128, fp);
		if (*buff == 'P') {
			if (*(buff+1) != '6')
				printf ("Warning.. not a binary ppm file?\n");
		} else if ((*buff != '#') && (*buff != '\n')) {
			if (!*width) {
				sscanf (buff, "%d %d", width, height);
				fgets (buff, 128, fp);
				break;
			}
		}
	}
	if (*width && *height)
		return (1);
	return (0);
}

/*
 * todo: renaming of structures
 */
gt_atom *
write_moov_atom (FILE *fp, int width, int height, int num_frames, int tpf,
		int format)
{
	int i;
	gt_stsd_atom *stsd;
	gt_stts_atom *stts;
	gt_stsc_atom *stsc;
	gt_stsz_atom *stsz;
	gt_stco_atom *stco;
	gt_stbl_atom *stbl;
	gt_vmhd_atom *vmhd;
	gt_hdlr_atom *minf_hdlr;
	gt_hdlr_atom *mdia_hdlr;
	gt_dref_atom *dref;
	gt_dinf_atom *dinf;
	gt_mdhd_atom *mdhd;
	gt_tkhd_atom *tkhd;
	gt_trak_atom *trak;
	gt_mdia_atom *mdia;
	gt_mvhd_atom *mvhd;
	gt_udta_atom *udta;
	gt_atom *minf, *moov;

	/* sample description atom */
	stsd = gt_alloc_atom (GTA_sample_desc, 1);
	stsd->count = 1;
	stsd->tab->size = 86;
    stsd->tab->format = format;
    stsd->tab->index = 1;   /* points to an entry in 'dref' */
    stsd->tab->width = width;
    stsd->tab->height = height;
    stsd->tab->hres.high = 72;
    stsd->tab->vres.high = 72;
    stsd->tab->frame_count = 1;
	strcpy (stsd->tab->comp_name+1, GT_COMP_RAW);
	stsd->tab->comp_name[0] = strlen (GT_COMP_RAW);
	stsd->tab->depth =24;
	stsd->tab->ctab_id = -1;
	/* time to sample atom */
    stts = gt_alloc_atom (GTA_time_to_sample, 1);
    stts->count = 1;
    stts->tab->num_samples = num_frames;
    stts->tab->duration = tpf;
	/* sample to chunk  */
    stsc = gt_alloc_atom (GTA_sample_to_chunk, 1);
    stsc->count = 1;
    stsc->tab->first_chunk = 1;
    stsc->tab->samples_per_chunk = stts->tab->num_samples;
    stsc->tab->sample_id = 1;   /* point to the first entry in the stsd tab!? */
	/* sample size atom .. */
	stsz = gt_alloc_atom (GTA_sample_size, num_frames);
	stsz->sample_size = 0;
	stsz->count = num_frames;
	for (i = 0; i < num_frames; i++ ) {
		stsz->tab[i].size = width * height * 3;
	}
	/* sample chunk offset atom */
	stco = gt_alloc_atom (GTA_chunk_offset, 1);
	stco->count = 1;
	stco->tab[0].offset = 0;    /*  offset of mdat */
    /* sample table */
    stbl = gt_alloc_atom (GTA_sample_table, 5);
    stbl->memb = 5;
    stbl->suba[0] = (gt_atom*)stsd;
    stbl->suba[1] = (gt_atom*)stts;
    stbl->suba[2] = (gt_atom*)stsc;
    stbl->suba[3] = (gt_atom*)stsz;
    stbl->suba[4] = (gt_atom*)stco;
    stbl->size = 8 +
            stsd->size + stts->size + stsc->size + stsz->size + stco->size;
    /* video media information header */
    vmhd = gt_alloc_atom (GTA_video_media_header, 0);
    vmhd->flags[2] = 1;
	/* data handler reference atom ??? */
	minf_hdlr = gt_alloc_atom (GTA_handler_ref, 0);
	minf_hdlr->comp_type = GT_DATA_REF;
	minf_hdlr->comp_subtype = GT_ALIAS;
	minf_hdlr->comp_man = GT_COMP_MAN;
	/* */
    dref = gt_alloc_atom (GTA_data_ref, 1);
    dref->count = 1;
    dref->tab->size = 12;
    dref->tab->type = GT_ALIAS;
    dref->tab->flags[2]= 0x01;  /* self reference */
	/* */
    dinf = gt_alloc_atom (GTA_data_info, 1);
    dinf->memb = 1;
    dinf->suba[0] = (gt_atom *)dref;
    dinf->size = 8 + dref->size;

    /* media information atom */
    minf = gt_alloc_atom (GTA_media_info, 4);
    minf->memb = 4;
    minf->suba[0] = (gt_atom *)vmhd;
    minf->suba[1] = (gt_atom *)minf_hdlr;
    minf->suba[2] = (gt_atom *)dinf;
    minf->suba[3] = (gt_atom *)stbl;
    minf->size += vmhd->size + minf_hdlr->size + dinf->size + stbl->size;
	/* media header */
    mdhd = gt_alloc_atom (GTA_media_header, 0);
    mdhd->ctime = gt_time();
    mdhd->mtime = gt_time();
    mdhd->time_scale = 1000;
    mdhd->duration = tpf * num_frames;
	/* media handler reference atom */
    mdia_hdlr = gt_alloc_atom (GTA_handler_ref, strlen(GT_MID_HDLR_NAME));
    mdia_hdlr->comp_type = GT_MEDIA_REF;
    mdia_hdlr->comp_subtype = GT_VIDEO;
    mdia_hdlr->comp_man = GT_COMP_MAN;
    mdia_hdlr->comp_flags = 0x40000000;     /* ? */
    mdia_hdlr->comp_flags_mask = 0x00010047;    /* ? */
    strcpy (mdia_hdlr->comp_name+1, GT_MID_HDLR_NAME);
    mdia_hdlr->comp_name[0] = strlen (GT_MID_HDLR_NAME);
    mdia_hdlr->size = 32 + 1 +strlen (GT_MID_HDLR_NAME);
	/* media atom */
	mdia = gt_alloc_atom (GTA_media, 3);
	mdia->memb = 3;
	mdia->suba[0] = (gt_atom *)mdhd;
    mdia->suba[1] = (gt_atom *)mdia_hdlr;
    mdia->suba[2] = (gt_atom *)minf;
    mdia->size += mdhd->size + mdia_hdlr->size + minf->size;
	/* track header */
    tkhd = gt_alloc_atom (GTA_track_header,0);
    tkhd->flags[2] = (char)(0x01 | 0x02);
    tkhd->ctime = gt_time();
    tkhd->mtime = gt_time();
    tkhd->track_id = 1;
    tkhd->duration = tpf * num_frames;
    tkhd->matrix[1]  = 1;   /* 1/1/1 */
    tkhd->matrix[17] = 1;
    tkhd->matrix[32] = 64;
    tkhd->width.high = width;
    tkhd->height.high= height;
	/* track */
    trak = gt_alloc_atom (GTA_track, 2);
    trak->memb = 2;
    trak->suba[0] = (gt_atom *)tkhd;
    trak->suba[1] = (gt_atom *)mdia;
    trak->size += tkhd->size + mdia->size;
	/* movie header */
    mvhd = gt_alloc_atom (GTA_movie_header, 0);
    mvhd->ctime = gt_time();
    mvhd->mtime = gt_time();
    mvhd->time_scale = 1000;
    mvhd->duration = tkhd->duration;
    mvhd->pref_rate.high = 1;
    mvhd->matrix[1] =  1;   /* 1/1/1 */
    mvhd->matrix[17] = 1;
    mvhd->matrix[32] = 64;
    mvhd->next_track_id = 2;
    /* user data
        no space for the text pointers is provided! */
    udta = gt_alloc_atom (GTA_user_data, 3);
    udta->tab[0]->type = GT_UD_INFO;
    udta->tab[0]->tlen = strlen ("Made by 'ppm2qt'");
    udta->tab[0]->size = 8 + 4 + udta->tab[0]->tlen;
    udta->tab[0]->text = "Made by 'ppm2qt'";
    udta->tab[1]->type = GT_UD_PRODUCER;
    udta->tab[1]->tlen = strlen ("ppm2qt User");
    udta->tab[1]->size = 8 + 4 + udta->tab[1]->tlen;
    udta->tab[1]->text = "ppm2qt User";
    udta->tab[2]->type = GT_UD_LOOP;
    udta->tab[2]->size = 8;
    udta->size = 8 +udta->tab[0]->size +udta->tab[1]->size +udta->tab[2]->size;
    /* movie atom, with 3 subatoms */
    moov = gt_alloc_atom (GTA_movie, 3);
    moov->memb = 3;
    moov->suba[0] = (gt_atom *)mvhd;
    moov->suba[1] = (gt_atom *)udta;
    moov->suba[2] = (gt_atom *)trak;
    moov->size += mvhd->size + udta->size + trak->size;
	stco->tab[0].offset = moov->size + 8 ;    /*  offset of mdat */
	if (!gt_write_atom (moov, fp)) {
		perror ("write_moov_atom()");
		exit (1);
	}
	return (moov);
}

/*
 * ppm2qt, all frames must have the same size and must
 * be an raw ppm file..
 */
int
main (int argc, char *argv[]) {
	int c, num_frames, verbose = 0;
	int width = 0, height = 0;
	int y, i, ti, time_per_frame=40;
	char *outfile = NULL, *infile = NULL;
	byte *line;
	FILE *fp, *outfp;
	int input_is_jpeg = 0;
	int format = GT_VID_FMT_RAW;
	byte *buf = NULL;
	gt_atom *moov;

	while ((c = getopt (argc, argv, "?ho:vt:js:")) != EOF) {
		switch (c) {
			case 'o':
				outfile = optarg;
				break;
			case 'v':
				verbose = 1;
				break;
			case 't':
				/* default = 40 tpf =~ 25 fps */
				time_per_frame = atoi(optarg);
				break;
			case 'j':
				input_is_jpeg = 1;
				format = GT_VID_FMT_JPEG;
				break;
			case 's':
				sscanf (optarg, "%dx%d", &width, &height);
				break;
			case '?':
			case 'h':
			default:
				usage (argv[0]);
				break;
		}
	}
	num_frames = argc - optind;
	if (!outfile || !num_frames)
		usage (argv[0]);

	if (input_is_jpeg && (!width || !height)) {
		fprintf (stderr, "You must specify the size!\n");
		usage (argv[0]);
	} else if (!input_is_jpeg) {
		/* read the first file to get the size
		 */
		if (width || height) {
			fprintf (stderr, "Size option only allowed for ppm files\n");
			usage (argv[0]);
		}
		infile = argv[optind];
		if (verbose)
			printf ("reading size from '%s'\n", infile);
		if ((fp = fopen (infile, "rb")) == NULL) {
			perror (infile);
			usage (argv[0]);
			exit (2);
		}
		if (!read_ppm_header (fp, &width, &height)) {
			printf ("%s: not a ppm file?\n", infile);
		}
		fclose (fp);
	} else {
		buf = malloc (width * height * 3);
	}
	if (!width || !height) {
		printf ("failed! no width or height found\n");
		exit (3);
	}
	/* open output file
	 */
	if ((outfp = fopen (outfile, "wb")) == NULL) {
		perror (infile);
		exit (4);
	}
	/* write moov atom
	 */
	moov = write_moov_atom (outfp,
				width, height, num_frames, time_per_frame, format);
	/* write mdat size/atom type
	 */
	gt_write4byte (8 + num_frames * width * height * 3, outfp);
	gt_write4byte (GTA_movie_data, outfp);

	line = malloc (width * 3);
	/* loop for every frame
	 */
	for (i = 0; i < num_frames; i++) {
		infile = argv[optind+i];
		if (verbose)
			printf ("infile = '%s'\n", infile);
		if ((fp = fopen (infile, "rb")) == NULL) {
			perror (infile);
			exit (6);
		}
		if (input_is_jpeg) {
			int len;
			len = fread (buf, 1, width * height * 3, fp);
			fwrite (buf, 1, len, outfp);
			((gt_stsz_atom *)(
				moov ->
				suba[2] ->
				suba[1] -> /* mdia */
				suba[2] -> /* minf */
				suba[3] -> /* stbl */
				suba[3]))-> /* stsz */
						tab[i].size = len;
		} else {
			if (!read_ppm_header (fp, &ti, &ti)) {
				printf ("%s: no ppm file?\n", infile);
			} else {
				for (y = 0; y < height; y++) {
					fread (line, 1, width*3, fp);
					fwrite (line, 1, width * 3, outfp);
				}
			}
		}
		fclose (fp);
	}
	if (input_is_jpeg) {
		fseek (outfp, 0, SEEK_SET);
		gt_write_atom (moov, outfp);
	}
	fclose (outfp);
	return (0);
}

