/*
 * ppm2qtvr.c
 * just a dirty hack!, does NOT work!!!
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include "gt.h"
#include "gtvr.h"

/*
 */
static void
usage (char *progname)
{
	printf ("Usage: %s [-v] [-o <output>] <ppm-file>\n", progname);
	exit (1);
}

/*
 * read ppm header of a rawbits ppm file (P6)
 */
int
read_ppm_header (FILE *fp, int *width, int *height)
{
	char buff[128];

	*width = *height = 0;
	while (*width == 0) {
		fgets (buff, 128, fp);
		if (*buff == 'P') {
			if (*(buff+1) != '6')
				printf ("Warning.. not a binary ppm file?\n");
		} else if (*buff != '#')
			if (!*width) {
				sscanf (buff, "%d %d", width, height);
				fgets (buff, 128, fp);
				break;
			}
	}
	if (*width && *height)
		return (1);
	return (0);
}

/*
 * ppm2qt, all frames must have the same size and must
 * be an raw ppm file..
 */
int
main (int argc, char *argv[]) {
	int c, verbose = 0;
	char *outfile = NULL, *infile;
	gt_image img, **imgl;
	FILE *fp, *outfp;
	int width = 0, height = 0;
	int size, rc;
	int num_frames = 8;
	char *buf;

	while ((c = getopt (argc, argv, "?hf:o:v")) != EOF) {
		switch (c) {
			case 'o':
				outfile = optarg;
				break;
			case 'v':
				verbose = 1;
				break;
			case 'f':
				num_frames = atoi (optarg);
				break;
			case '?':
			case 'h':
			default:
				usage (argv[0]);
				break;
		}
	}
	if (!num_frames)
		usage (argv[0]);

	/* read the first file to get the size
	 */
	infile = argv[optind];
	if (verbose)
		printf ("reading size from '%s'\n", infile);

	if ((fp = fopen (infile, "rb")) == NULL) {
		perror (infile);
		usage (argv[0]);
		return (2);
	}
	if (!read_ppm_header (fp, &width, &height)) {
		printf ("%s: not a ppm file?\n", infile);
	}
	if (!width || !height) {
		printf ("failed! no width or height found\n");
		return (3);
	}
	size = width * height * 3;
	img.img = malloc (size);
	if (!img.img) {
		perror ("malloc()");
		return (4);
	}
	img.width = width;
	img.height= height;
	img.depth = 3;

	/* read the image */
	rc = fread (img.img, 1, size, fp);
	if (rc < size) {
		fprintf (stderr, "Warning: short read in source file\n");
	}
	fclose (fp);
	rc = gt_vr_dice (&img, num_frames, &imgl);
	if (verbose)
		fprintf (stderr, "%d frames\n", rc);

	rc = gt_vr_new_from_diced (imgl, rc, &buf);
	if (rc) {
		if (outfile) {
			outfp = fopen (outfile, "wb");
			if (!outfp)
				return 1;
		} else {
			outfp = stdout;
		}
		fwrite (buf, 1, rc, outfp);
	} else {
		fprintf (stderr, "Conversion failed\n");
		return 1;
	}
	return (0);
}

