/*
 * gtk2_control.c
 *
 * Copyright (C) 2003,04 Karl H. Beckers, Frankfurt
 * EMail: khb@jarre-de-the.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "../config.h" //autoconf output

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>              /* isdigit() */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <X11/Xmu/WinUtil.h>
#ifdef HAVE_LIBZ
#include <zlib.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <pango/pango-layout.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include "led_meter.h"

#ifdef HAVE_LIBAVCODEC
#ifdef HAVE_LIBAVFORMAT
#include <ffmpeg/avcodec.h>
#include <ffmpeg/avformat.h>
#endif // HAVE_AVCODEC
#endif // HAVE_AVFORMAT

#include "job.h"
#include "capture.h"
//#include "main.h"
#include "app_data.h"
#include "util.h"
#include "gtk2_support.h"
#include "gtk2_options.h"
#include "frame.h"
#include "gtk2_frame.h"

#define GLADE_HOOKUP_OBJECT(component, widget, name) \
g_object_set_data_full(G_OBJECT(component), name, \
gtk_widget_ref(widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component, widget, name) \
g_object_set_data(G_OBJECT(component), name, widget)


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 animate_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (1040) */
  "\0\0\4("
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (80) */
  "\0\0\0P"
  /* width (20) */
  "\0\0\0\24"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377"
  "\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0"
  "\0\377\0\0\0\377\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0"
  "\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0"
  "\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377"
  "\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0"
  "\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0"
  "\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0"
  "\377\0\0\0\377\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 edit_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (624) */
  "\0\0\2\210"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (48) */
  "\0\0\0""0"
  /* width (12) */
  "\0\0\0\14"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 move_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (676) */
  "\0\0\2\274"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (52) */
  "\0\0\0""4"
  /* width (13) */
  "\0\0\0\15"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0"
  "\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0"
  "\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\0"
  "\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\0\0"
  "\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377"
  "\377\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 next_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (468) */
  "\0\0\1\354"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (36) */
  "\0\0\0$"
  /* width (9) */
  "\0\0\0\11"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
  "\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\0"
  "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 pause_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (728) */
  "\0\0\2\360"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (56) */
  "\0\0\0""8"
  /* width (14) */
  "\0\0\0\16"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 prev_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (468) */
  "\0\0\1\354"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (36) */
  "\0\0\0$"
  /* width (9) */
  "\0\0\0\11"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
  "\377\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0"
  "\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 record_on_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (676) */
  "\0\0\2\274"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (52) */
  "\0\0\0""4"
  /* width (13) */
  "\0\0\0\15"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\0\0\377\377\0\0\377"
  "\377\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\0\0\377"
  "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
  "\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
  "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\0\0\377\377\0\0\377\377\0\0\377\377"
  "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\0\0\377\377\0\0\377\377"
  "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
  "\377\0\0\377\377\0\0\377\377\0\0\377\377\377\377\0\377\377\377\0\377"
  "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
  "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\377"
  "\377\0\377\377\377\0\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
  "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
  "\377\377\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\0\0\377"
  "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
  "\377\377\0\0\377\377\0\0\377\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
  "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\0\0\377"
  "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
  "\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\0\0\377\377\0\0"
  "\377\377\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 select_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (676) */
  "\0\0\2\274"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (52) */
  "\0\0\0""4"
  /* width (13) */
  "\0\0\0\15"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377\377\377\377\0"
  "\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0"
  "\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377\377\0"
  "\377\377\377\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377"
  "\377\0\377\377\377\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377"
  "\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\377\377\377\0\0\0\0\377\377\377\377\0\0\0\0\377"
  "\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 step_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (780) */
  "\0\0\3$"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (60) */
  "\0\0\0<"
  /* width (15) */
  "\0\0\0\17"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\377\377"
  "\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0"
  "\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0"
  "\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0"
  "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0"
  "\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377"
  "\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0"
  "\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377"
  "\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
  "\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0"
  "\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377"
  "\377\377\0"
};


/* GdkPixbuf RGBA C-Source image dump */

static const guint8 stop_icon[] =
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (728) */
  "\0\0\2\360"
  /* pixdata_type (0x1010002) */
  "\1\1\0\2"
  /* rowstride (56) */
  "\0\0\0""8"
  /* width (14) */
  "\0\0\0\16"
  /* height (13) */
  "\0\0\0\15"
  /* pixel_data: */
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377"
  "\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377"
  "\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
  "\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377"
  "\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377"
  "\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
  "\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377"
  "\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377"
  "\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0\0\377\0\0\0\377\0\0"
  "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
  "\0\0\377\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\0\0"
  "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
  "\0\0\377\0\0\0\377\0\0\0\377\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377\0\377\377\377"
  "\0\377\377\377\0\377\377\377\0\377\377\377\0"
};


// globals
// need to define this here, because we're calling it from
// an event here
GtkWidget *dialog1;
GtkWidget *window1;
GtkWidget *handlebox1;
GtkWidget *hbox1;
//GtkWidget *menubar1;
//GtkWidget *MI_file;
GtkWidget *MI_file_menu;
GtkWidget *MI_preferences;
GtkWidget *image36;
GtkWidget *MI_prefs_save;
GtkWidget *image32;
GtkWidget *MI_make_video;
GtkWidget *MI_continue;
GtkWidget *image33;
GtkWidget *MI_help;
GtkWidget *image34;
GtkWidget *separatormenuitem1, *separatormenuitem2;
GtkWidget *MI_quit1;
GtkWidget *image35;
GtkWidget *filename;
GtkWidget *toolbar3;
GtkWidget *toolbar2;
GtkWidget *tmp_toolbar_icon;
GtkWidget *stop;
GtkWidget *pause_tb;
GtkWidget *record;
GtkWidget *step;
GtkWidget *previous;
GtkWidget *next;
GtkWidget *move;
GtkWidget *select_tb;
GtkWidget *MI_animate;
GtkWidget *edit;
GtkWidget *frame_drop_meter;
GtkTooltips *tooltips;

// more globals
static Job *jobp;
static guint stop_timer_id, start_timer_id;
struct timeval curr_time;
long start_time, pause_time, time_captured;

void start_recording(Job *job);
GtkWidget* create_window1(char *param_animate_cmd, char *param_mkvideo_cmd,
char *param_edit_cmd, char *param_help_cmd);
void InitGTKControl(AppData *app);
gboolean stop_recording_gui_stuff(Job *jobp);
gboolean stop_recording_nongui_stuff(Job *jobp);
gboolean timer_start_recording (Job *job);
void GtkChangeLabel(int pic_no);



/*
 * XVIDCAP GUI API ( IF THAT WORD IS ALLOWED HERE ;) )
 *
 * XVC_PREINIT IS FOR GUI PREINITIALIZATION LIKE SETTING FALLBACK OPTIONS
 * XVC_CREATEGUI IS FOR GUI CREATION
 * XVC_CREATEFRAME SHOULD CREATE THE SELECTION FRAME
 * XVC_INITGUI IS FOR MISCELLANEOUS INITIALIZATION STUFF
 * XVC_RUNGUI IS A WRAPPER AROUND THE UI'S MAIN LOOP
 *
 * XVC_ADDTIMEOUT IS A WRAPPER AROUND THE GUI'S FUNCTIONALITY FOR TRIGGERING ACTIONS AT A
 * GIVEN TIME
 * XVC_CHANGEGUILABEL IS A WRAPPER AROUND A FUNCTION TO CHANGE THE DISPLAY
 * OF THE CURRENT FRAME NUMBER (NOT NECESSARY IN A LABEL)
 * XVC_STOPCAPTURE IS A HOOK FOR RESETTING THE GUI TO A STOPPED STATE
 * XVC_STARTCAPTURE IS A HOOK FOR STARTING A CAPTURE SESSION
 */

Boolean XVC_PreInit( int argc, char **argv, AppData *app ) {
    // the gtk gui doesn't recognize the Xt ressources as fallback values
    // one effect is that here cap_width and cap_height will be zerio if
    // not explicitly set
    // FIXME: research other side-effects .....
    if ( app->cap_width == 0 || app->cap_height == 0 ) {
        app->cap_width = 192;
        app->cap_height = 144;
    }
    //other defaults from fallback.h
    // FIXME: this should be user-definable
    app->play_cmd = "animate \"%s\" -delay %d &";
    app->video_cmd = "ppm2mpeg \"%s\" %d %d %d %d %f %d &";
    app->edit_cmd = "display \"%s\" &";
    app->help_cmd = "xterm -e man xvidcap &";
    
    //still other defaults
    app->file = "test.mpeg";
    app->fps = 10;
    app->time = 0;
    app->frames = 1000;
    
    gtk_init(&argc, &argv);
    
    return TRUE;
}


Boolean XVC_CreateGUI(AppData *app) {
    int pos_x, pos_y;
    Display *dpy;
    
    #ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
    #endif
    gtk_set_locale();
    //add_pixmap_directory("/usr/local/share/project2/pixmaps");
    
    window1 = create_window1(app->play_cmd, app->video_cmd, app->edit_cmd, app->help_cmd);
    if ( ! ( app->flags & FLG_NOGUI ) ) {
        gtk_widget_show(window1);
        gtk_window_get_position( GTK_WINDOW(window1), &pos_x, &pos_y);
        gtk_window_move( GTK_WINDOW(window1), (pos_x + FRAME_WIDTH), pos_y);
        
        dpy = GDK_DRAWABLE_XDISPLAY( GTK_WIDGET(window1)->window );
    } else {
        dpy = XOpenDisplay(NULL);
    }
    #ifdef HasDGA
    if (!XF86DGAQueryExtension(dpy, &dga_evb, &dga_errb))
        app->flags &= ~FLG_USE_DGA;
    else {
        int flag = 0;
        XF86DGAQueryDirectVideo(dpy, XDefaultScreen(dpy), &flag);
        if ((flag & XF86DGADirectPresent) == 0) {
            app->flags &= ~FLG_USE_DGA;
            if (app->verbose) {
                printf("xfdga: no direct present\n");
            }
        }
    }
    #endif //HasDGA
    
    #ifdef HAVE_SHMAT
    if (!XShmQueryExtension(dpy))
        app->flags &= ~FLG_USE_SHM;
    #endif //HAVE_SHMAT
    
    if (app->flags & FLG_NOGUI ) {
        XCloseDisplay(dpy);
    }
    return TRUE;
}


Boolean XVC_CreateFrame(AppData *app) {
    if ( app->cap_width == 0 ) app->cap_width = 10;
    if ( app->cap_height == 0 ) app->cap_height = 10;
    GtkCreateFrame( GTK_WINDOW(window1), app->cap_width, app->cap_height, app->flags );
    return TRUE;
}


Boolean XVC_InitGUI(AppData *app) {
    InitGTKControl(app);
    return TRUE;
}


int XVC_RunGUI() {
    gtk_main();
    return 0;
}


void XVC_AddTimeout(int ms, void *func, Job *job) {
    gtk_timeout_add((guint32) ms, (GtkFunction) func, job);
}


void XVC_ChangeGUILabel( int pic_no ) {
    GtkChangeLabel( pic_no );
}


void XVC_StopCapture(Job *job) {
    gboolean rc;
    
    rc = stop_recording_nongui_stuff(job);
    rc = stop_recording_gui_stuff(job);
}


void XVC_StartCapture(Job *job) {
    gboolean rc;
    
    rc = start_recording_nongui_stuff(job);
    rc = start_recording_gui_stuff(job);
}


void XVC_ChangeFrame(int x, int y, int width, int height, Boolean reposition_control ) {
    GtkChangeFrame(x, y, width, height, reposition_control );
}


void XVC_FrameMonitor(Job *job, int measured_time) {
    int percent, diff, n;
   
    if ( measured_time == 0 ) {
        percent = 0;
    } 
    else if ( measured_time <= job->time_per_frame ) percent = 30;
    else if ( measured_time >= (job->time_per_frame * 2)) percent = 100;
    else {
        diff = measured_time - job->time_per_frame;
        percent = diff * 70 / job->time_per_frame;
        percent += 30;
    }
//    printf("percent: %i\n", percent); 
    led_meter_set_percent (LED_METER(frame_drop_meter), percent);

    if ( percent == 0 ) LED_METER(frame_drop_meter)->old_max_da = 0;
}


/*
 * HELPER FUNCTIONS ...
 *
 *
 */

gint keySnooper (GtkWidget *grab_widget, GdkEventKey *event, gpointer func_data) {
    printf("keyval: %i - mods: %i\n", event->keyval, event->state);
}


/*
 * change value of frame/filename display
 */
void
GtkChangeLabel(int pic_no) {
    PangoLayout *layout;
    gint width, height, old_handlebox_width, old_filename_width;
    int filename_length;
    
    static char file[PATH_MAX+1], tmp_buf[PATH_MAX+1];
    static int blub;
    gboolean ignore = TRUE;
    GdkRectangle r;
    GdkEvent eev;
    
    if (jobp->flags & FLG_MULTI_IMAGE) {
        sprintf(tmp_buf, jobp->file, jobp->movie_no);
        sprintf(file, "%s[%04d]", tmp_buf, pic_no);
//        sprintf(file, "%s[%04d]", jobp->file, pic_no);
    } else {
        sprintf(file, jobp->file, pic_no);
    }
    filename_length = strlen(file);
    if (filename_length > 60) {
        char tmp_file[PATH_MAX+1];
        char *tmp_file2, *ptr, *ptr2;
        int n;
        
        strncpy(tmp_file, file, 20);
        tmp_file[20] = 0;
        n = filename_length - 20;
        ptr = (char*) &file + n;
        tmp_file2 = strncat(tmp_file, "...", 4);
        tmp_file2 = strncat(tmp_file, ptr, 45);
        strncpy(file, tmp_file2, 45);
    }
    
    gtk_button_set_label(GTK_BUTTON(filename), file);
    
    layout = gtk_widget_create_pango_layout(filename, file);
    pango_layout_get_pixel_size(layout, &width, &height);
    g_object_unref(layout);
    
    gtk_widget_set_size_request(GTK_WIDGET(filename), (width + 30), -1);
    
}



// first callbacks here ....
//
//

//on_window1_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
gboolean
on_window1_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data) {
    if ((jobp->state & VC_STOP) == 0 ) XVC_StopCapture(jobp);
    DestroyFrame();
    return FALSE;
}

gboolean
on_window1_destroy(GtkWidget *widget, GdkEvent *event, gpointer user_data) {
    gtk_main_quit();
}

void
on_MI_preferences_activate(GtkMenuItem *menuitem, gpointer user_data) {
    dialog1 = create_dialog1(jobp);
    gtk_widget_show(dialog1);
}

void
on_MI_prefs_save_activate(GtkMenuItem *menuitem, gpointer user_data) {
    XVC_WriteOptionsFile(jobp);
}

void
on_MI_continue_activate(GtkMenuItem *menuitem, gpointer user_data) {
    if ( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ) {
        if ( (! is_filename_mutable(jobp->file)) || (! jobp->flags & FLG_MULTI_IMAGE) ) {
            printf("Output not a video file or no counter in filename\nDisabling autocontinue!\n");
            gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menuitem), FALSE);
        } else {
            jobp->flags |= FLG_AUTO_CONTINUE;
        }
    } else {
        jobp->flags &= ~FLG_AUTO_CONTINUE;
    }
}

void
on_MI_make_video_activate(GtkMenuItem *menuitem, gpointer user_data) {
    char *fmt = (char *)user_data;
    char cmd[PATH_MAX*2+2];
    sprintf(cmd, fmt, jobp->file, jobp->start_no, jobp->pic_no-1,
    jobp->area->width, jobp->area->height, jobp->fps, jobp->time_per_frame);
    if (jobp->flags & FLG_RUN_VERBOSE)
        printf("calling: '%s'\n", cmd);
    
    system(cmd);
}

void
on_MI_help_activate(GtkMenuItem *menuitem, gpointer user_data) {
    if (jobp->flags & FLG_RUN_VERBOSE)
        printf("calling '%s'\n", (char*) user_data);
    system((char*)user_data);
}

void
on_MI_quit1_activate(GtkMenuItem *menuitem, gpointer user_data) {
    gboolean ignore;
    g_signal_emit_by_name((GtkObject*) window1, "destroy", &ignore);
}


gboolean stop_recording_nongui_stuff(Job *job) {
    // non-gui stuff
    job->state = VC_STOP;

    return FALSE;
}

gboolean stop_recording_gui_stuff(Job *job) {
    // GUI stuff
//    gtk_widget_set_sensitive(GTK_WIDGET(MI_file), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(select_tb), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(record), TRUE);

    gtk_widget_set_sensitive(GTK_WIDGET(MI_file_menu), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(edit), TRUE);
    
    if (! ((jobp->flags & FLG_MULTI_IMAGE) != 0 && is_filename_mutable(jobp->file) != TRUE )) {
        gtk_widget_set_sensitive(GTK_WIDGET(next), TRUE);
        if ((jobp->flags & FLG_MULTI_IMAGE) == 0) {
            if (jobp->pic_no >= jobp->step) gtk_widget_set_sensitive(GTK_WIDGET(previous), TRUE);
        } else {
            if (jobp->movie_no > 0) gtk_widget_set_sensitive(GTK_WIDGET(previous), TRUE);
        }
    }
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pause_tb), FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(record), FALSE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(stop), TRUE);
    
//    if (!(jobp->flags & FLG_RUN_VERBOSE))
        GtkChangeLabel(jobp->pic_no);

    return FALSE;    
}


gboolean timer_stop_recording(Job *job) {
    if ( job->flags & FLG_AUTO_CONTINUE) {
        stop_recording_nongui_stuff(job);
        job->state |= VC_CONTINUE;
    } else {
        stop_recording_nongui_stuff(job);
        stop_recording_gui_stuff(job);
    }
    return FALSE;
}


void
on_stop_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    if (gtk_toggle_button_get_active(togglebutton)) {
        if (stop_timer_id) gtk_timeout_remove(stop_timer_id);
        stop_recording_nongui_stuff(jobp);
        stop_recording_gui_stuff(jobp);
    } else {
        // empty
    }
}


gboolean start_recording_gui_stuff(Job *job) {
    // GUI stuff
    gtk_widget_set_sensitive(record, FALSE);
//    gtk_widget_set_sensitive(MI_file, FALSE);
    if ((jobp->state & VC_PAUSE) == 0) gtk_widget_set_sensitive(stop, TRUE);
    gtk_widget_set_sensitive(select_tb, FALSE);
    gtk_widget_set_sensitive(pause_tb, TRUE);
    
    gtk_widget_set_sensitive(MI_file_menu, FALSE);
    gtk_widget_set_sensitive(edit, FALSE);
    
    if (jobp->state & VC_PAUSE) {
        if ( (jobp->flags & FLG_MULTI_IMAGE) == 0 ) {
            gtk_widget_set_sensitive(step, TRUE);
            gtk_widget_set_sensitive(next, TRUE);
            if (jobp->pic_no >= jobp->step ) gtk_widget_set_sensitive(previous, TRUE);
        } else {
            gtk_widget_set_sensitive(step, FALSE);
            if ( ! is_filename_mutable(jobp->file) ) {
                gtk_widget_set_sensitive(next, FALSE);
                gtk_widget_set_sensitive(previous, FALSE);
            }
        }
    } else {
        gtk_widget_set_sensitive(next, FALSE);
        gtk_widget_set_sensitive(previous, FALSE);
    }

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(stop), FALSE);
    
    return FALSE;
}

gboolean start_recording_nongui_stuff(Job *job) {
    // non-gui stuff
    // hiermit wird auch VC_READY zurckgesetzt ...
    job->state = (VC_REC | VC_START) | (job->state & VC_PAUSE);
    
    if (job->flags & FLG_MULTI_IMAGE) {
        job->pic_no = jobp->start_no;
        GtkChangeLabel(jobp->pic_no);
    }
    
    
    if (job->max_time && (job->state & VC_PAUSE) == 0 ) {
        /* install a timer which stops recording
         * we need milli secs ..
         */
        gettimeofday(&curr_time, NULL);
        time_captured = 0;
        start_time = curr_time.tv_sec * 1000 + curr_time.tv_usec / 1000;
        stop_timer_id = gtk_timeout_add((guint32)(jobp->max_time * 1000), (GtkFunction) timer_stop_recording, jobp);
    }
    
    job->capture(jobp, NULL);
    
    return FALSE;
}


void
on_record_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    if (gtk_toggle_button_get_active(togglebutton)) {
        start_recording_gui_stuff(jobp);
        start_recording_nongui_stuff(jobp);
    } else {
        //empty
    }
} 


void
on_pause_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    #ifdef DEBUG
    printf("on_pause_toggled(%d)\n", (int) gtk_toggle_button_get_active(togglebutton));
    #endif
    if (gtk_toggle_button_get_active(togglebutton)) {
        // stop timer handling only if max_time is configured
        if (jobp->max_time ) {
            gettimeofday(&curr_time, NULL);
            pause_time = curr_time.tv_sec * 1000 + curr_time.tv_usec / 1000;
            if (( jobp->state & VC_REC ) != 0 ) {
                time_captured = ( pause_time - start_time ) + time_captured;
            } else {
                time_captured = 0;
            }
            if (stop_timer_id) gtk_timeout_remove(stop_timer_id);
        }
        
        jobp->state |= VC_PAUSE;
        jobp->state &= ~VC_STOP;
        
        // GUI stuff
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(stop), FALSE);
//        gtk_widget_set_sensitive(GTK_WIDGET(stop), TRUE);
        if ((jobp->flags & FLG_MULTI_IMAGE) == 0 && jobp->state & VC_REC) {
            gtk_widget_set_sensitive(GTK_WIDGET(step), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(next), TRUE);
            if (jobp->pic_no >= jobp->step) gtk_widget_set_sensitive(GTK_WIDGET(previous), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(edit), TRUE);
        }
    } else {
        jobp->state &= ~VC_PAUSE;
        jobp->state &= ~VC_STEP;
        // step is always only active if a running recording session is paused
        // so releasing pause can always deactivate it
        gtk_widget_set_sensitive(GTK_WIDGET(step), FALSE);
        // the following only when recording is going on (not when just pressing and
        // releasing pause
        if (jobp->state & VC_REC) {
            gtk_widget_set_sensitive(GTK_WIDGET(next), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(previous), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(edit), FALSE);
        }
/*        if (jobp->state & VC_REC) {
            gtk_widget_set_sensitive(GTK_WIDGET(stop), TRUE);
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(stop), FALSE);
        } */
        
        // restart timer handling only if max_time is configured
        if (jobp->max_time) {
            /* install a timer which stops recording
             * we need milli secs ..
             */
            gettimeofday(&curr_time, NULL);
            start_time = curr_time.tv_sec * 1000 + curr_time.tv_usec / 1000;
            stop_timer_id = gtk_timeout_add((guint32)(jobp->max_time * 1000 - time_captured), (GtkFunction) timer_stop_recording, jobp);
        }
    }
    
}


void
on_step_clicked(GtkButton *button, gpointer user_data) {
    if (( jobp->flags & FLG_MULTI_IMAGE ) == 0 ) {
        if (!(jobp->state & (VC_PAUSE | VC_REC)))
            return;
        jobp->state |= VC_STEP;
        jobp->capture(jobp, NULL);
        if (jobp->pic_no == jobp->step ) gtk_widget_set_sensitive(GTK_WIDGET(previous), TRUE);
    }
}

void
on_filename_clicked(GtkButton *button, gpointer user_data) {
    if ( ( jobp->flags & FLG_MULTI_IMAGE ) == 0 ) {
        if ( jobp->pic_no != jobp->start_no && ( jobp->state & VC_STOP ) > 0 
                    || ( jobp->state & VC_PAUSE ) > 0 ) {
            jobp->pic_no = jobp->start_no;
            GtkChangeLabel(jobp->pic_no);
        }
    } else {
        if ( jobp->movie_no != 0 && ( jobp->state & VC_STOP ) > 0) {
            jobp->movie_no = 0;
            jobp->pic_no = jobp->start_no;
            GtkChangeLabel(jobp->pic_no);
        }
    }
}

void
on_previous_clicked(GtkButton *button, gpointer user_data) {
    if (( jobp->flags & FLG_MULTI_IMAGE ) == 0 ) {
        if ( jobp->pic_no >= jobp->step) {
            jobp->pic_no -= jobp->step;
            GtkChangeLabel(jobp->pic_no);
        } else {
            fprintf(stderr, "previous button active although picture number < step. this should never happen\n");
        }
        if ( jobp->pic_no < jobp->step ) gtk_widget_set_sensitive(GTK_WIDGET(previous), FALSE);
    } else {
        if ( jobp->movie_no > 0) {
            jobp->movie_no -= 1;
            GtkChangeLabel(jobp->pic_no);
        } else {
            fprintf(stderr, "previous button active although movie number == 0. this should never happen\n");
        }
        if ( jobp->movie_no == 0 ) gtk_widget_set_sensitive(GTK_WIDGET(previous), FALSE);
    }
}

void
on_next_clicked(GtkButton *button, gpointer user_data) {
    if (( jobp->flags & FLG_MULTI_IMAGE ) == 0 ) {
        jobp->pic_no += jobp->step;
        GtkChangeLabel(jobp->pic_no);
        if (jobp->pic_no == jobp->step ) gtk_widget_set_sensitive(GTK_WIDGET(previous), TRUE);
    } else {
        jobp->movie_no += 1;
        GtkChangeLabel(jobp->pic_no);
        if (jobp->movie_no == 1) gtk_widget_set_sensitive(GTK_WIDGET(previous), TRUE);
    }
}


void on_move_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    GtkTooltips *tooltips;
    XRectangle *frame_rectangle;
    int x, y, pheight, pwidth;
    
    tooltips = gtk_tooltips_new ();
    
    if (gtk_toggle_button_get_active(togglebutton)) {
        XVC_frame_lock = 1; // button pressed = move frame with control
        gtk_tooltips_set_tip (tooltips, GTK_WIDGET (togglebutton), _ ("Detach selection frame"), NULL);
        
        gtk_window_set_gravity( GTK_WINDOW(window1), GDK_GRAVITY_NORTH_WEST );
        gtk_window_get_position( GTK_WINDOW(window1), &x, &y);
        gtk_window_get_size( GTK_WINDOW(window1), &pwidth, &pheight);
        gtk_window_set_gravity( GTK_WINDOW(window1), GDK_GRAVITY_STATIC );
        gtk_window_get_position( GTK_WINDOW(window1), &x, &y);
        gtk_window_get_size( GTK_WINDOW(window1), &pwidth, &pheight);
        if (x < 0)
            x = 0;
        y += pheight + FRAME_OFFSET;
        if (y < 0)
            y = 0;
        frame_rectangle = GetArea();
        XVC_ChangeFrame(x, y, frame_rectangle->width, frame_rectangle->height, FALSE);
    } else {
        XVC_frame_lock = 0;
        gtk_tooltips_set_tip (tooltips, GTK_WIDGET (togglebutton), _ ("Attach selection frame"), NULL);
    }
}


void
on_select_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    if (gtk_toggle_button_get_active(togglebutton)) {
        Display *display = GDK_DRAWABLE_XDISPLAY( GTK_WIDGET(window1)->window );
        Cursor cursor;
        Window root, target = None, temp = None;
        XEvent event;
        int buttons = 0;
        int x_down, y_down, x_up, y_up, x, y, pheight = 0, pwidth = 0;
        int width, height;
        XGCValues gcv;
        GC gc;
        
        root = RootWindow(display, DefaultScreen(display));
        cursor = XCreateFontCursor(display, XC_crosshair);
        
        gcv.background = XBlackPixel(display, XDefaultScreen(display));
        gcv.foreground = XWhitePixel(display, XDefaultScreen(display));
        gcv.function = GXinvert;
        gcv.plane_mask = gcv.background ^ gcv.foreground;
        gcv.subwindow_mode = IncludeInferiors;
        gc = XCreateGC(display, root,
        GCBackground | GCForeground | GCFunction | GCPlaneMask | GCSubwindowMode, &gcv);
        /* grab the mouse
         */
        if (XGrabPointer(display, root, False,
        PointerMotionMask|ButtonPressMask|ButtonReleaseMask,
        GrabModeSync, GrabModeAsync, root, cursor, CurrentTime)
        != GrabSuccess) {
            printf("Can't grab mouse!\n");
            return;
        }
        x_down = y_down = x_up = y_up = width = height = 0;
        
        while (buttons < 2) {
            /* allow pointer events */
            XAllowEvents(display, SyncPointer, CurrentTime);
            /* search in the queue for button events */
            XWindowEvent(display, root,
            PointerMotionMask|ButtonPressMask|ButtonReleaseMask, &event);
            switch (event.type) {
                case ButtonPress:
                    x_down = event.xbutton.x;
                    y_down = event.xbutton.y;
                    target = event.xbutton.subwindow; /* window selected */
                    if (target == None) {
                        target = root;
                    }
                    buttons++;
                    break;
                case ButtonRelease:
                    x_up = event.xbutton.x;
                    y_up = event.xbutton.y;
                    buttons++;
                    break;
                default:
                    /* motion notify */
                    if (buttons == 1) {
                        if (width) {
                            /* remove old frame */
                            XDrawRectangle(display, root, gc, x, y, width, height);
                        }
                        /* button is pressed */
                        if (x_down > event.xbutton.x) {
                            width = x_down - event.xbutton.x + 1;
                            x = event.xbutton.x;
                        } else {
                            width = event.xbutton.x - x_down + 1;
                            x = x_down;
                        }
                        if (y_down > event.xbutton.y) {
                            height = y_down - event.xbutton.y + 1;
                            y = event.xbutton.y;
                        } else {
                            height = event.xbutton.y - y_down + 1;
                            y = y_down;
                        }
                        XDrawRectangle(display, root, gc, x, y, width, height);
                    }
                    break;
            }
        }
        if (width) /* remove old frame */
            XDrawRectangle(display, root, gc, x, y, width, height);
        XUngrabPointer(display, CurrentTime);      /* Done with pointer */
        XFreeCursor(display, cursor);
        XFreeGC(display, gc);
        
        if ((x_down != x_up) && (y_down != y_up)) {
            /* an individual frame was selected
             */
            if (x_up < x_down) {
                width = x_down - x_up + 2;
                x = x_up;
            } else {
                width = x_up - x_down + 2;
                x = x_down;
            }
            if (y_up < y_down) {
                height = y_down - y_up + 2;
                y = y_up;
            } else {
                height = y_up - y_down + 2;
                y = y_down;
            }
            if (target != root)
                target = XmuClientWindow(display, target);
            XGetWindowAttributes(display, target, &jobp->win_attr);
            jobp->win_attr.width = width;
            jobp->win_attr.height = height;
        } else {
            /* if (target == root) {
             printf ("Drag your mouse to select an area on the root window.\n");
             return;
             } */
            if (target != root) {
                /* get the real window */
                target = XmuClientWindow(display, target);
            }
            XGetWindowAttributes(display, target, &jobp->win_attr);
            XTranslateCoordinates(display, target, root, 0, 0, &x, &y, &temp);
        }
        
        jobp->win_attr.x = x;
        jobp->win_attr.y = y;
        
        /* we must move the panel a little bit, so get the height of
         the panel to adjust the y value */
        gtk_window_set_gravity( GTK_WINDOW(window1), GDK_GRAVITY_STATIC );
        //        	gtk_window_get_position ( GTK_WINDOW (window1), &x, &y);
        gtk_window_get_size( GTK_WINDOW(window1), &pwidth, &pheight);
        
        /* add the space between the panel and the frame */
        // FIXME: find out how to determine real title bar height, if possible
        // this is just to get the main control out of the way, because
        // if we have the frame locked, the move will trigger the move callback
        // however, this will not leave the selection at the right coordinates
        // because we're not moving the control enough, because we don*t know
        // the height of the title bar ...
        
        pheight = pheight + FRAME_OFFSET;
        if (IsFrameLocked()) {
            gtk_window_move(GTK_WINDOW(window1), x, y - pheight);
        }
        
        if (jobp->flags & FLG_RUN_VERBOSE) {
            printf("Original Selection geometry: %dx%d+%d+%d\n",
            jobp->win_attr.width, jobp->win_attr.height, x, y);
        }
        #ifdef HAVE_LIBAVCODEC
        #ifdef HAVE_LIBAVFORMAT
        /*
         * make sure we have even width and height for ffmpeg
         */
        if (jobp->target >= CAP_FFM) {
            Boolean changed = FALSE;
            int w, h;
            
            if ((jobp->win_attr.width % 2) > 0 ) {
                jobp->win_attr.width--;
                changed = TRUE;
            }
            if ((jobp->win_attr.height % 2) > 0) {
                jobp->win_attr.height--;
                changed = TRUE;
            }
            if ( jobp->win_attr.width < 20 ) {
                jobp->win_attr.width = 20;
                changed = TRUE;
            }
            if ( jobp->win_attr.height < 20 ) {
                jobp->win_attr.height = 20;
                changed = TRUE;
            }
            
            if (changed) {
                if (jobp->flags & FLG_RUN_VERBOSE) {
                    printf("Modified Selection geometry: %dx%d+%d+%d\n",
                    jobp->win_attr.width, jobp->win_attr.height, x, y);
                }
            }
        }
        #endif
        #endif
        GtkChangeFrame(x, y, jobp->win_attr.width, jobp->win_attr.height, FALSE);
        
        jobp->ncolors = GetColors(display, &jobp->win_attr, &jobp->colors);
        if (jobp->get_colors) {
            if (jobp->color_table)
                free(jobp->color_table);
            jobp->color_table = (*jobp->get_colors)(jobp->colors, jobp->ncolors);
        }
        if (jobp->flags & FLG_RUN_VERBOSE) {
            fprintf(stderr, "color_table first entry: 0x%.8X\n", *(u_int32_t*)jobp->color_table);
        }
        job_set_save_function(jobp->win_attr.visual, jobp->target, jobp);
        #ifdef DEBUG
        printf("new visual: %d\n", jobp->win_attr.visual->class);
        #endif
    }
    gtk_toggle_button_set_active(togglebutton, FALSE);
}

void
on_MI_animate_activate(GtkButton *button, gpointer user_data) {
    char file[PATH_MAX+1], buff[PATH_MAX*2+1], *p;
    char *cmd = (char *) user_data;
    int i = 0, n=0;
    
    p = jobp->file;
    while (*p) {
        if (*p == '%') {
            p++;
            sscanf(p, "%dd", &n);
            while (n) {
                file[i++] = '?';
                n--;
            }
            while (isdigit(*p))
                p++;
            p++;
        } else {
            file[i] = *p;
            p++;
            i++;
        }
    }
    file[i] = '\0';
    sprintf(buff, cmd, file, jobp->time_per_frame);
    if (jobp->flags & FLG_RUN_VERBOSE);
    printf("calling: '%s'\n", buff);
    
    system(buff);
}

void
on_edit_clicked(GtkButton *button, gpointer user_data) {
    char cmd[PATH_MAX*2+4];
    char buf[PATH_MAX+1];
    int n;
    
    if (jobp->pic_no < 1)
        n = 0;
    else
        n = jobp->pic_no - 1;
    
    sprintf(buf, jobp->file, n);
    sprintf(cmd, (char*)user_data, buf);
    if (jobp->flags & FLG_RUN_VERBOSE)
        printf("calling: '%s'\n", cmd);
    
    system(cmd);
}


void position_popup_menu (GtkMenu *menu, gint *x, gint *y,
    gboolean *push_in, gpointer user_data) {
        
    int pwidth = 0, pheight = 0, px = 0, py = 0, tx = 0, ty = 0;
    GtkWidget *w;
                               
    w = GTK_WIDGET(filename);
    pheight = w->allocation.height;
                                                 
    while ( ( GTK_WIDGET_FLAGS(w) & GTK_TOPLEVEL ) == 0 ) {
//        printf("widget name: %s\n", gtk_widget_get_name(w) );
        px = w->allocation.x;
        py = w->allocation.y;
        tx += px;
        ty += py;
        w = gtk_widget_get_parent(w);
    }
    
    gtk_window_get_position( GTK_WINDOW(w), &px, &py);
    tx += px;
    ty += py;
    
    *x = tx;
    *y = ty + pheight;
}

// this pops up the menu on right click on filename button
static gint menu_popup( GtkWidget *widget,
                          GdkEvent *event )
{
    gboolean is_sensitive;
    
    GdkEventButton *bevent = (GdkEventButton *) event; 
    g_object_get((gpointer) MI_file_menu, (gchar*) "sensitive", &is_sensitive, NULL);
    if (bevent->button == (guint) 3 && is_sensitive == TRUE ) {
        gtk_menu_popup (GTK_MENU (widget), NULL, NULL, position_popup_menu, NULL,
                        bevent->button, bevent->time);
        /* Tell calling code that we have handled this event; the buck
         * stops here. */
        return TRUE;
    }
    /* Tell calling code that we have not handled this event; pass it on. */
    return FALSE;
}

// this handles the shortcut keybindings for the menu
static gint window_key_pressed( GtkWidget *widget,
                          GdkEvent *event )
{
    gboolean is_sensitive;

    GdkEventKey *kevent = (GdkEventKey *) event; 
//    printf("keyval: %i - mods: %i\n", kevent->keyval, kevent->state);

    g_object_get((gpointer) MI_file_menu, (gchar*) "sensitive", &is_sensitive, NULL);

    if (kevent->keyval == 112 && kevent->state == 4 && is_sensitive == TRUE ) {
        gtk_menu_item_activate(GTK_MENU_ITEM(MI_preferences));
        return TRUE;
    } else if (kevent->keyval == 113 && kevent->state == 4 && is_sensitive == TRUE ) {
        gtk_menu_item_activate(GTK_MENU_ITEM(MI_quit1));
        return TRUE;
    }
    /* Tell calling code that we have not handled this event; pass it on. */
    return FALSE;
}



// now the widget
//
//
GtkWidget*
create_window1(char *param_animate_cmd, char *param_mkvideo_cmd,
char *param_edit_cmd, char *param_help_cmd) {

    GtkAccelGroup *accel_group;
    
    tooltips = gtk_tooltips_new ();
    accel_group = gtk_accel_group_new ();
    
    window1 = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window1), _("video capture"));
    gtk_window_set_resizable(GTK_WINDOW(window1), FALSE);

    hbox1 = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox1);
    gtk_container_add(GTK_CONTAINER(window1), hbox1);
/*    
    menubar1 = gtk_menu_bar_new();
    gtk_widget_show(menubar1);
    gtk_box_pack_start(GTK_BOX(hbox1), menubar1, FALSE, FALSE, 0);
    
    MI_file = gtk_menu_item_new_with_mnemonic(_("_File"));
    gtk_widget_show(MI_file);
    gtk_container_add(GTK_CONTAINER(menubar1), MI_file);
*/    
    MI_file_menu = gtk_menu_new();
//    gtk_menu_item_set_submenu(GTK_MENU_ITEM(MI_file), MI_file_menu);
    
    MI_preferences = gtk_image_menu_item_new_with_mnemonic(_("_Preferences"));
    gtk_widget_show(MI_preferences);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), MI_preferences);
    gtk_widget_add_accelerator (MI_preferences, "activate", accel_group,
                              GDK_p, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
    
    image32 = gtk_image_new_from_stock("gtk-preferences", GTK_ICON_SIZE_MENU);
    gtk_widget_show(image32);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(MI_preferences), image32);
    
    MI_prefs_save = gtk_image_menu_item_new_with_mnemonic(_("_Save Preferences"));
    gtk_widget_show(MI_prefs_save);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), MI_prefs_save);
    
    image36 = gtk_image_new_from_stock("gtk-floppy", GTK_ICON_SIZE_MENU);
    gtk_widget_show(image36);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(MI_prefs_save), image36);

    MI_continue = gtk_check_menu_item_new_with_mnemonic(_("Auto_continue (y/n)"));
    gtk_widget_show(MI_continue);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), MI_continue);
    
    separatormenuitem2 = gtk_menu_item_new();
    gtk_widget_show(separatormenuitem2);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), separatormenuitem2);
    gtk_widget_set_sensitive(separatormenuitem2, FALSE);
    
    MI_make_video = gtk_image_menu_item_new_with_mnemonic(_("_Make Video"));
    gtk_widget_show(MI_make_video);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), MI_make_video);
    
    image33 = gtk_image_new_from_stock("gtk-execute", GTK_ICON_SIZE_MENU);
    gtk_widget_show(image33);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(MI_make_video), image33);

    MI_animate = gtk_image_menu_item_new_with_mnemonic(_("_Animate"));
    gtk_widget_show(MI_animate);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), MI_animate);
//    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(MI_animate), image33);
    
    /*    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, animate_icon, FALSE, NULL) );
    animate = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_BUTTON,
    NULL,
    _("Animate"),
    _("Make animated GIF of captured individual frames"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(animate); */
    
    MI_help = gtk_image_menu_item_new_with_mnemonic(_("_Help"));
    gtk_widget_show(MI_help);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), MI_help);
    
    image34 = gtk_image_new_from_stock("gtk-help", GTK_ICON_SIZE_MENU);
    gtk_widget_show(image34);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(MI_help), image34);
    
    separatormenuitem1 = gtk_menu_item_new();
    gtk_widget_show(separatormenuitem1);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), separatormenuitem1);
    gtk_widget_set_sensitive(separatormenuitem1, FALSE);
    
    MI_quit1 = gtk_image_menu_item_new_with_mnemonic(_("_Quit"));
    gtk_widget_show(MI_quit1);
    gtk_container_add(GTK_CONTAINER(MI_file_menu), MI_quit1);
    gtk_widget_add_accelerator (MI_quit1, "activate", accel_group,
                              GDK_q, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
    
    image35 = gtk_image_new_from_stock("gtk-quit", GTK_ICON_SIZE_MENU);
    gtk_widget_show(image35);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(MI_quit1), image35);
    
    toolbar2 = gtk_toolbar_new();
    gtk_widget_show(toolbar2);
    gtk_box_pack_start(GTK_BOX(hbox1), toolbar2, FALSE, FALSE, 0);
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar2), GTK_TOOLBAR_TEXT);
    
    filename = gtk_button_new_with_label(_("filename"));
    gtk_button_set_use_underline(GTK_BUTTON(filename), FALSE);
    g_object_set((gpointer) filename, (gchar*) "can-focus", (gboolean) FALSE, NULL);
    gtk_widget_show(filename);
//    gtk_box_pack_start(GTK_BOX(hbox1), filename, FALSE, FALSE, 0);
    gtk_widget_set_size_request(filename, 130, -1);
    gtk_tooltips_set_tip (tooltips, filename, _ ("Reset frame counter and filename"), NULL);
    gtk_toolbar_insert_widget (GTK_TOOLBAR (toolbar2), filename,
            "Reset frame counter and filename", "Reset frame counter and filename", 0);
    
    frame_drop_meter = led_meter_new ();
    gtk_widget_show(frame_drop_meter);
    gtk_box_pack_start(GTK_BOX(hbox1), frame_drop_meter, FALSE, FALSE, 0);
    led_meter_set_tip(LED_METER(frame_drop_meter), "Monitor current frame rate\nyellow = 10-50 % too slow\nred = 50+ % too slow");

    toolbar3 = gtk_toolbar_new();
    gtk_widget_show(toolbar3);
    gtk_box_pack_start(GTK_BOX(hbox1), toolbar3, FALSE, FALSE, 0);
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar3), GTK_TOOLBAR_ICONS);
    
    //tmp_toolbar_icon = create_pixmap(window1, "stop.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, stop_icon, FALSE, NULL) );
    stop = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
    NULL,
    _("_STOP"),
    _("Stop recording"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
//    gtk_widget_set_sensitive(stop, FALSE);
    gtk_widget_show(stop);
    //    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(stop), TRUE);
    
    //tmp_toolbar_icon = create_pixmap(window1, "pause.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, pause_icon, FALSE, NULL) );
    pause_tb = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
    NULL,
    _("_PAUSE"),
    _("Pause recording"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(pause_tb);
//    gtk_widget_set_sensitive(pause_tb, FALSE);
    
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar3));
    
    //tmp_toolbar_icon = create_pixmap(window1, "record_on.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, record_on_icon, FALSE, NULL) );
    record = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
    NULL,
    _("_RECORD"),
    _("Start recording"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(record);
    
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar3));
    
    //tmp_toolbar_icon = create_pixmap(window1, "step.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, step_icon, FALSE, NULL) );
    step = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_BUTTON,
    NULL,
    _("Capture single frame"),
    _("Capture single frame"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(step);
    gtk_widget_set_sensitive(step, FALSE);
    
    //tmp_toolbar_icon = create_pixmap(window1, "prev.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, prev_icon, FALSE, NULL) );
    previous = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_BUTTON,
    NULL,
    _("Move cursor back one frame"),
    _("Move cursor back one frame"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(previous);
    
    //tmp_toolbar_icon = create_pixmap(window1, "next.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, next_icon, FALSE, NULL) );
    next = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_BUTTON,
    NULL,
    _("Move cursor to next frame"),
    _("Move cursor to next frame"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(next);
    
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar3));
    
    //tmp_toolbar_icon = create_pixmap(window1, "move.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, move_icon, FALSE, NULL) );
    move = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
    NULL,
    _("Sticky Selection"),
    _("Detach selection frame"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(move);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(move), TRUE);
    
    //tmp_toolbar_icon = create_pixmap(window1, "select.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, select_icon, FALSE, NULL) );
    select_tb = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
    NULL,
    _("Modify Selection"),
    _("Select rectangular area to capture"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(select_tb);
    
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar3));
    
    //tmp_toolbar_icon = create_pixmap(window1, "animate.png");
/*    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, animate_icon, FALSE, NULL) );
    animate = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_BUTTON,
    NULL,
    _("Animate"),
    _("Make animated GIF of captured individual frames"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(animate); */
    
    //tmp_toolbar_icon = create_pixmap(window1, "edit.png");
    tmp_toolbar_icon = gtk_image_new_from_pixbuf( gdk_pixbuf_new_from_inline(-1, edit_icon, FALSE, NULL) );
    edit = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar3),
    GTK_TOOLBAR_CHILD_BUTTON,
    NULL,
    _("Edit"),
    _("Edit current individual frame"), NULL,
    tmp_toolbar_icon, NULL, NULL);
    gtk_label_set_use_underline(GTK_LABEL(((GtkToolbarChild*) (g_list_last(GTK_TOOLBAR(toolbar3)->children)->data))->label), TRUE);
    gtk_widget_show(edit);
    
    g_signal_connect((gpointer) window1, "delete_event",
    G_CALLBACK(on_window1_delete_event),
    NULL);
    g_signal_connect((gpointer) window1, "destroy",
    G_CALLBACK(on_window1_destroy),
    NULL);
    g_signal_connect_swapped (G_OBJECT (window1), "key_press_event",
	                      G_CALLBACK (window_key_pressed), 
                              NULL);
    g_signal_connect((gpointer) MI_preferences, "activate",
    G_CALLBACK(on_MI_preferences_activate),
    NULL);
    g_signal_connect((gpointer) MI_prefs_save, "activate",
    G_CALLBACK(on_MI_prefs_save_activate),
    jobp);
    g_signal_connect((gpointer) MI_continue, "activate",
    G_CALLBACK(on_MI_continue_activate),
    jobp);
    g_signal_connect((gpointer) MI_make_video, "activate",
    G_CALLBACK(on_MI_make_video_activate),
    param_mkvideo_cmd);
    g_signal_connect((gpointer) MI_animate, "activate",
    G_CALLBACK(on_MI_animate_activate),
    param_animate_cmd);
    g_signal_connect((gpointer) MI_help, "activate",
    G_CALLBACK(on_MI_help_activate),
    param_help_cmd);
    g_signal_connect((gpointer) MI_quit1, "activate",
    G_CALLBACK(on_MI_quit1_activate),
    NULL);
    g_signal_connect((gpointer) stop, "toggled",
    G_CALLBACK(on_stop_toggled),
    NULL);
    g_signal_connect((gpointer) pause_tb, "toggled",
    G_CALLBACK(on_pause_toggled),
    NULL);
    g_signal_connect((gpointer) record, "toggled",
    G_CALLBACK(on_record_toggled),
    NULL);
    g_signal_connect((gpointer) record, "activate",
    G_CALLBACK(on_record_toggled),
    NULL);
    g_signal_connect((gpointer) step, "clicked",
    G_CALLBACK(on_step_clicked),
    NULL);
    g_signal_connect((gpointer) filename, "clicked",
    G_CALLBACK(on_filename_clicked),
    NULL);
    g_signal_connect_swapped (G_OBJECT (filename), "button_press_event",
	                      G_CALLBACK (menu_popup), 
                              G_OBJECT (MI_file_menu));
    g_signal_connect((gpointer) previous, "clicked",
    G_CALLBACK(on_previous_clicked),
    NULL);
    g_signal_connect((gpointer) next, "clicked",
    G_CALLBACK(on_next_clicked),
    NULL);
    g_signal_connect((gpointer) move, "toggled",
    G_CALLBACK(on_move_toggled),
    NULL);
    g_signal_connect((gpointer) select_tb, "toggled",
    G_CALLBACK(on_select_toggled),
    NULL);
/*    g_signal_connect((gpointer) animate, "clicked",
    G_CALLBACK(on_animate_clicked),
    param_animate_cmd); */
    g_signal_connect((gpointer) edit, "clicked",
    G_CALLBACK(on_edit_clicked),
    param_edit_cmd);
    
    /* Store pointers to all widgets, for use by lookup_widget(). */
    GLADE_HOOKUP_OBJECT_NO_REF(window1, window1, "window1");
    GLADE_HOOKUP_OBJECT(window1, hbox1, "hbox1");
/*    GLADE_HOOKUP_OBJECT(window1, menubar1, "menubar1");
    GLADE_HOOKUP_OBJECT(window1, MI_file, "MI_file"); */
    GLADE_HOOKUP_OBJECT(window1, MI_file_menu, "MI_file_menu");
    GLADE_HOOKUP_OBJECT(window1, MI_preferences, "MI_preferences");
    GLADE_HOOKUP_OBJECT(window1, image32, "image32");
    GLADE_HOOKUP_OBJECT(window1, MI_prefs_save, "MI_prefs_save");
    GLADE_HOOKUP_OBJECT(window1, MI_continue, "MI_continue");
    GLADE_HOOKUP_OBJECT(window1, image36, "image36");
    GLADE_HOOKUP_OBJECT(window1, MI_make_video, "MI_make_video");
    GLADE_HOOKUP_OBJECT(window1, MI_animate, "MI_animate");
    GLADE_HOOKUP_OBJECT(window1, image33, "image33");
    GLADE_HOOKUP_OBJECT(window1, MI_help, "MI_help");
    GLADE_HOOKUP_OBJECT(window1, image34, "image34");
    GLADE_HOOKUP_OBJECT(window1, separatormenuitem1, "separatormenuitem1");
    GLADE_HOOKUP_OBJECT(window1, separatormenuitem2, "separatormenuitem2");
    GLADE_HOOKUP_OBJECT(window1, MI_quit1, "MI_quit1");
    GLADE_HOOKUP_OBJECT(window1, image35, "image35");
    GLADE_HOOKUP_OBJECT(window1, filename, "filename");
    GLADE_HOOKUP_OBJECT(window1, toolbar3, "toolbar3");
    GLADE_HOOKUP_OBJECT(window1, stop, "stop");
    GLADE_HOOKUP_OBJECT(window1, pause_tb, "pause");
    GLADE_HOOKUP_OBJECT(window1, record, "record");
    GLADE_HOOKUP_OBJECT(window1, step, "step");
    GLADE_HOOKUP_OBJECT(window1, previous, "previous");
    GLADE_HOOKUP_OBJECT(window1, next, "next");
    GLADE_HOOKUP_OBJECT(window1, move, "move");
    GLADE_HOOKUP_OBJECT(window1, select_tb, "select");
    GLADE_HOOKUP_OBJECT(window1, frame_drop_meter, "frame_drop_meter");
//    GLADE_HOOKUP_OBJECT(window1, animate, "animate");
    GLADE_HOOKUP_OBJECT(window1, edit, "edit");
    
    return window1;
}

void
InitGTKControl(AppData *app) {
    Display *mydisplay;
    Window root, topwin;
    
    char *param_file;
    int param_codec, compress;
    float param_fps, param_max_time;
    int param_max_frames, start_at_no, step, param_quality, mouseWanted;
    char *dev, *snd;
    int rate, size, channels, flags, bpp;
    char *param_animate_cmd, *param_mkvideo_cmd, *param_edit_cmd, *param_help_cmd;
    extern XVC_frame_lock;
    
    
    param_file = app->file;
    param_codec = app->targetCodec;
    compress = app->compress;
    param_fps = app->fps;
    param_max_time = app->time;
    param_max_frames = app->frames;
    start_at_no = app->start_no;
    step = app->step;
    param_quality = app->quality;
    mouseWanted = app->mouseWanted;
    dev = app->device;
    snd = app->snddev;
    rate = app->sndrate;
    size = app->sndsize;
    channels = app->sndchannels;
    flags = app->flags;
    bpp = app->bpp;
    param_animate_cmd = app->play_cmd;
    param_mkvideo_cmd = app->video_cmd;
    param_edit_cmd = app->edit_cmd;
    param_help_cmd = app->help_cmd;
    
    // xvidcap specific initialization
    // this is taken from control.c's CreateControl, but I don't want this
    // stuff in create_window (for parts can't put it there)
    
    if ( app->cap_pos_x >= 0 || app->cap_pos_y >=0 ) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(move), FALSE);
        XVC_frame_lock = 0;
    }
    
    if (! ( flags & FLG_NOGUI ) ) {
        mydisplay = GDK_DRAWABLE_XDISPLAY( GTK_WIDGET(window1)->window );
    } else {
        mydisplay = XOpenDisplay(NULL);
    }
    root = RootWindow(mydisplay, DefaultScreen(mydisplay));
    
    jobp = job_init(flags);
    
    jobp->area = GetArea();
    jobp->bpp = bpp;
    
    if (!XGetWindowAttributes(mydisplay, root, &jobp->win_attr))
        perror("Can't get window attributes!\n");
    // the default is to use the colormap of the root window
    jobp->ncolors = GetColors(mydisplay, &jobp->win_attr, &jobp->colors);
    
    /* find capture function */
    job_set_capture();
    
    /* set frames per second */
    job_set_fps(param_fps);
    
    /* jpeg quality parameter */
    job_set_quality(param_quality);
    
    /* png compression */
    job_set_compression(compress);
    
#ifdef HAVE_FFMPEG_AUDIO
    /* initialize sound recording parameters */
    job_set_sound_dev(snd, rate, size, channels);
#endif // HAVE_FFMPEG_AUDIO

    jobp->targetCodec = param_codec;
    jobp->mouseWanted = mouseWanted;
    
    jobp->max_time = param_max_time;
    jobp->max_frames = param_max_frames;
    jobp->start_no = start_at_no;
    jobp->pic_no = start_at_no;
    jobp->step = step;
    jobp->video_dev = dev;

    // get color table       
    if (jobp->get_colors)
        jobp->color_table = (*jobp->get_colors)(jobp->colors, jobp->ncolors);
    
    // set filename
    job_set_file(param_file);
    // unset autocontinue unless we capture to movie and file is mutable
    if ( jobp->flags & FLG_AUTO_CONTINUE && ( (! is_filename_mutable(jobp->file)) ||
                (jobp->flags & FLG_MULTI_IMAGE) == 0 ) ) {
        jobp->flags &= ~FLG_AUTO_CONTINUE;
        printf("Output not a video file or no counter in filename\nDisabling autocontinue!\n");
    }
    if ( jobp->flags & FLG_MULTI_IMAGE ) {
        if ( jobp->flags & FLG_AUTO_CONTINUE ) {
            gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), TRUE);
            gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), TRUE);
        } else {
            if ( is_filename_mutable(jobp->file)) {
                gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), TRUE);
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), FALSE);
            } else {
                gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), FALSE);
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), FALSE);
            }
        }
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), FALSE);
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), FALSE);
    }
    
    
    // set output handler (xto... .c)
    job_set_save_function(jobp->win_attr.visual, jobp->target, jobp);
    GtkChangeLabel(jobp->pic_no);
    
    #ifdef HAVE_LIBAVCODEC
    #ifdef HAVE_LIBAVFORMAT
    /*
     * make sure we have even width and height for ffmpeg
     */
    if (jobp->target >= CAP_FFM) {
        Boolean changed = FALSE;
        
        if (jobp->flags & FLG_RUN_VERBOSE) {
            fprintf(stderr, "control.InitControl(): Original dimensions: %i * %i\n", jobp->area->width, jobp->area->height);
        }
        if ((jobp->area->width % 2) > 0 ) {
            jobp->area->width--;
            changed = TRUE;
        }
        if ((jobp->area->height % 2) > 0) {
            jobp->area->height--;
            changed = TRUE;
        }
        if ( jobp->win_attr.width < 26 ) {
            jobp->win_attr.width = 26;
            changed = TRUE;
        }
        if ( jobp->win_attr.height < 26 ) {
            jobp->win_attr.height = 26;
            changed = TRUE;
        }
        
        if (changed) {
            GtkChangeFrame(jobp->area->x, jobp->area->y, jobp->area->width, jobp->area->height, FALSE);
            if (jobp->flags & FLG_RUN_VERBOSE) {
                fprintf(stderr, "control.InitControl(): Modified dimensions: %i * %i\n", jobp->area->width, jobp->area->height);
            }
        }
    }
    #endif
    #endif
    
    /* previous and next buttons have different meanings for on-the-fly encoding
     * and individual frame capture ... this sets the tooltips accordingly */
    if (( jobp->flags & FLG_MULTI_IMAGE ) == 0 ) {
        gtk_tooltips_set_tip (tooltips, previous, "Move cursor back one frame",
                "Move cursor back one frame");
        gtk_tooltips_set_tip (tooltips, next, "Move cursor to next frame",
                "Move cursor to next frame");
        gtk_tooltips_set_tip (tooltips, filename, 
            "Left Click: Reset frame counter and filename\nRight Click: Popup Menu",
            "Left Click: Reset frame counter and filename\nRight Click: Popup Menu");
        if (jobp->pic_no >= jobp->step ) gtk_widget_set_sensitive(previous, TRUE);
        else gtk_widget_set_sensitive(previous, FALSE);
    } else {
        if ( is_filename_mutable(jobp->file) ) {
            gtk_widget_set_sensitive(next, TRUE);
            if (jobp->movie_no > 0 ) gtk_widget_set_sensitive(previous, TRUE);
            else gtk_widget_set_sensitive(previous, FALSE);
        } else {
            gtk_widget_set_sensitive(next, FALSE);
            gtk_widget_set_sensitive(previous, FALSE);
        }
        gtk_tooltips_set_tip (tooltips, previous, "Move cursor to previous movie",
                "Move cursor to previous movie");
        gtk_tooltips_set_tip (tooltips, next, "Move cursor to next movie",
                "Move cursor to next movie");
        gtk_tooltips_set_tip (tooltips, filename, 
            "Left Click: Reset movie counter to zero\nRight Click: Popup Menu",
            "Left Click: Reset movie counter to zero\nRight Click: Popup Menu");
    }
    
    /* If we run without GUI, we autostart the recording */
    if ( jobp->flags & FLG_NOGUI ) {
        XCloseDisplay(mydisplay);
        gtk_init_add( (GtkFunction) start_recording_nongui_stuff, jobp );
    } 
    
    // register key_snooper for shortcuts ...
//    gtk_key_snooper_install(keySnooper, NULL);
    
}




