/*
 * video.c
 *
 * Copyright (C) 1998 Rasca, Berlin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HasVideo4Linux
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <linux/types.h>
#include <linux/videodev.h>
#include <stdlib.h>
#include <unistd.h>
#include "video.h"

/*
 * get image properties
 */
int
video_prop (VIDEO *v)
{
	int rc;
	struct video_picture vp;

	if (!v)
		return -1;
	rc = ioctl (v->fd, VIDIOCGPICT, &vp);
	if (rc != -1) {
		v->brightness = vp.brightness;
		v->hue = vp.hue;
		v->colour = vp.colour;
		v->contrast = vp.contrast;
		v->whiteness = vp.whiteness;
		v->depth = vp.depth;
		v->palette = vp.palette;
	}
	return (rc);
}

/*
 */
int
video_caps (VIDEO *v)
{
	struct video_capability vc;

	if (!v)
		return (-1);
	if (ioctl (v->fd, VIDIOCGCAP, &vc) == -1)
		return (-1);
	memcpy (v->name, vc.name, 32);
	v->type = vc.type;
	v->channels = vc.channels;
	v->audios = vc.audios;
	v->maxwidth = vc.maxwidth;
	v->maxheight =vc.maxheight;
	v->minwidth = vc.minwidth;
	v->minheight =vc.minheight;
	return (0);
}

/*
 */
void
video_free (VIDEO *v)
{
	free (v);
}

/*
 */
int
video_close (VIDEO *v)
{
	int rc = -1;
	if (!v)
		return (rc);
	if (v->fd > -1)
		rc = close (v->fd);
	video_free (v);
	return (rc);
}

/*
 */
VIDEO *
video_open (const char *dev, int flags)
{
	VIDEO *v = NULL;
	int fd;
	fd = open (dev, flags);
	if (fd == -1)
		return (NULL);
	v = malloc (sizeof (VIDEO));
	if (!v)
		return (NULL);
	v->fd = fd;
	if (video_caps (v) != 0) {
		video_close (v);
		return (NULL);
	}
	if (video_prop (v) != 0) {
		video_close (v);
		return (NULL);
	}
	return (v);
}

/*
 */
int
video_mmap (VIDEO *vid, int start)
{
	if (!vid)
		return (0);
	if (start) {
		vid->mmap = (char *) mmap (0, vid->size,
					PROT_READ | PROT_WRITE, MAP_SHARED, vid->fd, 0);
		if (vid->mmap == (char *)-1) {
			vid->mmap = NULL;
			return (0);
		}
	} else {
		/* free the mmap space */
		if (vid->mmap) {
			munmap (vid->mmap, vid->fd);
			vid->mmap = NULL;
		}
	}
	return (1);
}
#endif

