/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * hgfsDev.h --
 * 
 *    Header for code shared between the hgfs linux kernel module driver
 *    and the pserver.
 */

#ifndef _HGFS_DEV_H_
#define _HGFS_DEV_H_

#include "vm_basic_types.h"
#include "hgfs.h"

#define HGFS_NAME "vmware-hgfs"         // Name in /proc/fs
#define HGFS_DEVICE_NAME "dev"          // Name of our device under /proc/fs/HGFS_NAME/
#define HGFS_SUPER_MAGIC 0xbacbacbc     // Superblock magic number
#define HGFS_PROTOCOL_VERSION 1         // Incremented when something changes

/* 
 * Mount information, passed from pserver process to kernel
 * at mount time.
 */
typedef struct HgfsMountInfo {
   uint32 magicNumber;        // hgfs magic number
   uint32 version;            // protocol version
   uint32 fd;                 // file descriptor of client file
} HgfsMountInfo;

#endif //ifndef _HGFS_DEV_H_
