# We don't want make removing intermediary stamps
.SECONDARY :

build-arch: $(addprefix build-modules-,$(flavours))

# Prepare the out-of-tree build directory

prepare-%: $(stampdir)/stamp-prepare-%
	@# Empty for make to be happy
$(stampdir)/stamp-prepare-%: target_flavour = $*
$(stampdir)/stamp-prepare-%: $(confdir)/config $(confdir)/config.%
	@echo "Preparing $*..."
	install -d $(builddir)/build-$*
	touch $(builddir)/build-$*/ubuntu-build
	cd ubuntu-restricted; find . | cpio -dumpl $(builddir)/build-$*
	cat $^ > $(builddir)/build-$*/.config
	$(MAKE) -C kconfig kconfig
	cd $(builddir)/build-$* && $(CURDIR)/kconfig/kconfig -s Kconfig
	#sed -i 's;$$(src);$(builddir)/build-$*;' $(builddir)/build-$*/Makefile
	touch $@

# Do the actual build, including image and modules
build-modules-%: $(stampdir)/stamp-build-%
	@# Empty for make to be happy
$(stampdir)/stamp-build-%: target_flavour = $*
$(stampdir)/stamp-build-%: build_arch_t = $(call custom_override,build_arch,$*)
$(stampdir)/stamp-build-%: $(stampdir)/stamp-prepare-%
	@echo "Building $*..."
	$(kmake) $(conc_level) modules
	@touch $@

# Install the finished build
install-%: pkgdir = $(CURDIR)/debian/$(stub)-$(release)-$(abinum)-$*
install-%: aliasdir = $(pkgdir)//usr/share/linux-restricted-modules/$(release)-$(abinum)-$*/modules.alias.override
install-%: moddir = $(pkgdir)/lib/linux-restricted-modules/$(release)-$(abinum)-$*
install-%: build_arch_t = $(call custom_override,build_arch,$*)
install-%: target_flavour = $*
install-%: $(stampdir)/stamp-build-%
	dh_testdir
	dh_testroot
	dh_clean -k -p$(stub)-$(release)-$(abinum)-$*

	install -d -m755 $(aliasdir)

	export ARCH=$(build_arch_t); \
	for module in $(shell find $(builddir)/build-$* -name '*.ko'); do \
		$(SHELL) debian/split-module $$(basename $$module .ko) \
			$$(dirname $$module) $(moddir); \
		$(SHELL) debian/mod_supported $$module $(aliasdir); \
	done
		
	find $(moddir) -name \*.ko -print | while read f ; do strip --strip-debug "$$f"; done

	install -d $(pkgdir)/DEBIAN
	for script in postinst postrm; do					\
	  sed -e 's/@@KVER@@/$(release)-$(abinum)-$*/g'				\
	       debian/control-scripts/$$script > $(pkgdir)/DEBIAN/$$script;	\
	  chmod 755 $(pkgdir)/DEBIAN/$$script;					\
	done

binary-modules-%: pkgimg = $(stub)-$(release)-$(abinum)-$*
binary-modules-%: install-%
	dh_testdir
	dh_testroot

	dh_installchangelogs -p$(pkgimg)
	dh_installdocs -p$(pkgimg)
	dh_compress -p$(pkgimg)
	dh_fixperms -p$(pkgimg)
	dh_installdeb -p$(pkgimg)
	dh_gencontrol -p$(pkgimg)
	dh_md5sums -p$(pkgimg)
	dh_builddeb -p$(pkgimg) -- -Zbzip2 -z9


binary-debs: $(addprefix binary-modules-,$(flavours))
# Removed binary-udebs
binary-arch: binary-debs
