ARCH_CONFIGS=lpia

updateconfigs: kconfig/kconfig
	dh_testdir
	cp -a ubuntu-restricted build-restricted
	@for arch in $(ARCH_CONFIGS); do				\
		$(SHELL) debian/scripts/misc/oldconfig $$arch;		\
	done
	rm -rf build-restricted

printchanges:
	@git-log Ubuntu-$(release)-$(prev_revision)..HEAD | \
		perl -w -f debian/scripts/misc/git-ubuntu-log $(ubuntu_log_opts)

insertchanges:
	@perl -w -f debian/scripts/misc/insert-changes.pl

startnewrelease:
	dh_testdir
	@nextminor=$(shell expr `echo $(revision) | awk -F. '{print $$2}'` + 1); \
	user=$(shell whoami); \
	memyselfandirene="$$(getent passwd $$user | cut -d ":" -f 5 | cut -d "," -f 1)"; \
	now="$(shell date -R)"; \
	echo "Creating new changelog set for $(release)-$(abinum).$$nextminor..."; \
	echo -e "$(stub) ($(release)-$(abinum).$$nextminor) UNRELEASED; urgency=low\n" > debian/changelog.new; \
	echo "  CHANGELOG: Do not edit directly. Autogenerated at release." >> \
		debian/changelog.new; \
	echo "  CHANGELOG: Use the printchanges target to see the curent changes." \
		>> debian/changelog.new; \
	echo "  CHANGELOG: Use the insertchanges target to create the final log." \
		>> debian/changelog.new; \
	echo -e "\n -- $$memyselfandirene <$$user@ubuntu.com>  $$now\n" >> \
		debian/changelog.new ; \
	cat debian/changelog >> debian/changelog.new; \
	mv debian/changelog.new debian/changelog
