/* ------------------------------------------------------------------------
 * $Id: KitImpl.hh,v 1.8 2001/07/13 12:50:18 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-01 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _KitImpl_hh_
#define _KitImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Kit.hh"

// -- Class Declarations

class KitImpl : public virtual POA_Nobel::Kit,
		public virtual PortableServer::RefCountServantBase {
        
public:

    /**
     * Destructor.
     **/
    virtual ~KitImpl();
    
    // IDL Functions
    virtual char *name() = 0;
    virtual char *description() = 0;

protected:
    
    /**
     * Activate a servant created in the kit using the internal POA.
     * This will relinquish control of the reference-counted servant
     * to the POA itself, so deleting the POA (i.e. the kit) will
     * delete the servant as well.
     *
     * @param servant the servant to activate.
     **/
    template <typename Servant>
    inline Servant activate(Servant servant) {
	PortableServer::ObjectId_var oid = _poa->activate_object(servant);
	servant->_remove_ref();
	return servant;
    }
    
    /**
     * Deactivate a servant created in the kit using the internal POA.
     * 
     * @param servant the servant to deactivate.
     **/
    inline void deactivate(PortableServer::Servant servant) {
	const PortableServer::ObjectId_var oid = _poa->servant_to_id(servant);
	_poa->deactivate_object(oid);
    }

    /// Protected constructor (abstract base class)
    KitImpl();

    /// Internal portable object adapter (used for garbage-collection)
    PortableServer::POA_var _poa;

};

#endif /* KitImpl.hh */
