/* ------------------------------------------------------------------------
 * $Id: ParserFactory.cc,v 1.1 2001/08/16 11:32:25 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

// -- Local Includes
#include "Celsius/SAX/ExpatParser.hh"
#include "Celsius/SAX/ParserFactory.hh"

// -- Code Segment

SAX::Parser *SAX::ParserFactory::makeParser()
{
    // Create the default parser
    return makeParser("ExpatParser");
}

SAX::Parser *SAX::ParserFactory::makeParser(const std::string &name) 
{
    // Create and return a parser depending on name string
    if (name == "ExpatParser")
	return new ExpatParser();
    else
	return 0;
}
