# Part of the A-A-P recipe executive: Setup using GCC

# Copyright (c) 2002-2003 stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This module sets up variables and actions for using the GCC compiler tools.
#

from RecPython import *
import Global
from Action import action_add
from Dictlist import str2dictlist
from RecPos import RecPos


def exists():
    """
    Return TRUE when the GCC toolchain can be found.
    """
    # TODO: "cc" may also be gcc, use the gcc configure check for this.
    return program_path("gcc")


def define_actions():
    """
    Define the actions that GCC can accomplish.
    """
    # Allow the user to define the gcc command to be used with $GCC.
    rd = Global.globals
    if not rd.get("GCC"):
        rd["GCC"] = "gcc"

    # When "g++" or "gxx" can be found use it for compiling C++.  When it
    # cannot be found use "gcc" (causes problems when linking?).
    if not rd.get("GXX"):
        if program_path("g++"):
            rd["GXX"] = "g++"
        elif program_path("gxx"):
            rd["GXX"] = "gxx"
        else:
            rd["GXX"] = "gcc"

    rd = Global.globals
    rpstack = [ RecPos("compile_gcc action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_gcc object,libobject c"),
	    ":buildcheck $OPTIMIZE $?DEBUG\n"
            ":sys $GCC $CPPFLAGS $?DEFINE $?INCLUDE `cflags_normal()` "
                "$CFLAGS -o $target -c $source")

    rpstack = [ RecPos("compile_gcc dllobject action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_gcc dllobject c"),
	    ":buildcheck $OPTIMIZE $?DEBUG\n"
            ":sys $GCC $CPPFLAGS $?DEFINE $?INCLUDE `cflags_normal()` "
                "$CFLAGS -fPIC -o $target -c $source")

    rpstack = [ RecPos("compile_gxx action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_gxx object,libobject cpp"),
	    ":buildcheck $OPTIMIZE $?DEBUG\n"
            ":sys $GXX $CPPFLAGS $?DEFINE $?INCLUDE `cflags_normal()` "
                "$CXXFLAGS -o $target -c $source")

    rpstack = [ RecPos("compile_gxx dllobject action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_gcc dllobject cpp"),
	    ":buildcheck $OPTIMIZE $?DEBUG\n"
            ":sys $GXX $CPPFLAGS $?DEFINE $?INCLUDE `cflags_normal()` "
                "$CXXFLAGS -fPIC -o $target -c $source")

    rpstack = [ RecPos("build_gcc action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "build_gcc object"),
            ":sys $GCC $LDFLAGS `cflags_normal()` -o $target $source $?LIBS")

    rpstack = [ RecPos("build_gxx action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "build_gxx object"),
            ":sys $GXX $LDFLAGS `cflags_normal()` -o $target $source $?LIBS")

def use_actions(scope):
    """
    Setup variables so that the default actions use the GCC actions.
    """
    scope["C_COMPILE_ACTION"] = "compile_gcc"
    scope["CXX_COMPILE_ACTION"] = "compile_gxx"
    scope["C_BUILD_ACTION"] = "build_gcc"
    scope["CXX_BUILD_ACTION"] = "build_gxx"

# vim: set sw=4 et sts=4 tw=79 fo+=l:
