!{\src2tex{textfont=tt}}
!!****f* ABINIT/invars1m
!! NAME
!! invars1m
!!
!! FUNCTION
!! Initialisation phase : prepare the main input subroutine call by
!! reading all the NO MULTI variables, as well as the dimensions
!! needed for allocating the input arrays in abinit.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (XG, MKV)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  iout=unit number of output file
!!  lenstr=actual length of string
!!  mpi_enreg=informations about MPI parallelization
!!  msym=default maximal number of symmetries
!!  ndtset= number of datasets to be read; if 0, no multi-dataset mode
!!  ndtset_alloc=number of datasets, corrected for allocation of at least
!!               one data set.
!!  string*(*)=string of characters containing all input variables and data
!!  zion_max=maximal valence charge over all psps
!!
!! OUTPUT
!!  bravais_(11,0:ndtset_alloc)=characteristics of Bravais lattice (see symbrav.f)
!!  mband_upper_(0:ndtset_alloc)=list of mband_upper values
!!  mxmband_upper=maximal value of input nband for all the datasets
!!  mxnatsph=maximal value of input natsph for all the datasets
!!  mxncenter=maximal value of input ncenter for all the datasets
!!  mxnconeq=maximal value of input nconeq for all the datasets
!!  mxnkptgw=maximal value of input nkptgw for all the datasets
!!  mxnorb=maximal value of input norb for all the datasets
!!  mxnqptdm=maximal value of input nqptdm for all the datasets
!!  mxnkpt=maximal value of input nkpt for all the datasets
!!  mxnsppol=maximal value of input nsppol for all the datasets
!!  symafm_(1:msym,0:ndtset_alloc)=magnetic part of symmetry operation
!!  symrel_(3,3,1:msym,0:ndtset_alloc)=symmetry operations in real space in terms
!!   of primitive translations
!!  tnons_(3,1:msym,0:ndtset_alloc)=nonsymmorphic translations for symmetry operations
!!
!! SIDE EFFECTS
!!  dtsets(0:ndtset_alloc)=<type datafiles_type>contains all input variables,
!!   some of which are initialized here (see invars1.f for more details on the
!!   initialized records)
!!
!! NOTES
!! symrel_, symafm_ and tnons_ are actually called symreltmp_,
!! symafmtmp_  and tnonstmp_ in the calling routine.
!! Their dimensioning is a default one.
!!
!! PARENTS
!!      abinit
!!
!! CHILDREN
!!      invars1,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine invars1m(bravais_,dtsets,iout,lenstr,mband_upper_,mpi_enreg,&
& msym,mxmband_upper,mxnatsph,mxncenter,mxnconeq,&
& mxnkptgw,mxnkpt,mxnorb,mxnqptdm,mxnsppol,&
& ndtset,ndtset_alloc,string,symafm_,symrel_,tnons_,zion_max)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13iovars, except_this_one => invars1m
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iout,lenstr,msym,ndtset,ndtset_alloc
 integer,intent(out) :: mxmband_upper,mxnatsph,mxncenter,mxnconeq,mxnkpt
 integer,intent(out) :: mxnkptgw,mxnorb,mxnqptdm,mxnsppol
 real(dp),intent(in) :: zion_max
 character(len=*),intent(inout) :: string
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(out) :: bravais_(11,0:ndtset_alloc)
 integer,intent(out) :: mband_upper_(0:ndtset_alloc)
 integer,intent(out) :: symafm_(msym,0:ndtset_alloc)
 integer,intent(out) :: symrel_(3,3,msym,0:ndtset_alloc)
 real(dp),intent(out) :: tnons_(3,msym,0:ndtset_alloc)
 type(dataset_type),intent(inout) :: dtsets(0:ndtset_alloc)

!Local variables-------------------------------
!scalars
 integer :: i1,i2,idtset,ii,ipsp,isym,jdtset,mband_upper,nkpt,tjdtset,tread
 character(len=500) :: message
!arrays
 integer :: bravais(11)
 integer,allocatable :: symafm(:),symrel(:,:,:)
 real(dp),allocatable :: tnons(:,:)

!******************************************************************

 allocate(symafm(msym),symrel(3,3,msym),tnons(3,msym))

!Set up default values (note that the default acell, amu
!mkmem, mkmem1,mkqmem, and nkpt must be overcome
 bravais_(:,0)=0
 do idtset=0,ndtset_alloc
  dtsets(idtset)%amu(:)=-one
  dtsets(idtset)%acell_orig(:)=zero
  dtsets(idtset)%berryopt=0
! Only one component of densty is used presently
  dtsets(idtset)%densty(:,:)=zero
  dtsets(idtset)%efield(:)=zero
  dtsets(idtset)%iatfix(:,:)=0
  dtsets(idtset)%kptopt=0
  dtsets(idtset)%natsph=0
  dtsets(idtset)%ncenter=0
  dtsets(idtset)%nconeq=0
  dtsets(idtset)%nkptgw=0
  dtsets(idtset)%norb=0
  dtsets(idtset)%nqptdm=0
  dtsets(idtset)%optdriver=0
  dtsets(idtset)%rprim_orig(:,:)=zero
  dtsets(idtset)%rprim_orig(1,1)=one
  dtsets(idtset)%rprim_orig(2,2)=one
  dtsets(idtset)%rprim_orig(3,3)=one
  dtsets(idtset)%spinat(:,:)=zero
  dtsets(idtset)%symmorphi=1
  dtsets(idtset)%typat(:)=0
  dtsets(idtset)%vel_orig(:,:)=zero
  dtsets(idtset)%xred_orig(:,:)=zero
  dtsets(idtset)%so_typat(:)=1
 end do
 dtsets(:)%mkmem=-1
 dtsets(:)%mk1mem=-1
 dtsets(:)%mkqmem=-1
!natom is already initialized in invars0
 dtsets(0)%natom=-1
 dtsets(:)%nkpt=-1
 dtsets(:)%nsppol=1
 dtsets(:)%nsym=0
 symafm_(:,0)=1
 symrel_(:,:,:,0)=0
 symrel_(1,1,:,0)=1 ; symrel_(2,2,:,0)=1 ; symrel_(3,3,:,0)=1
 tnons_(:,:,0)=0.0_dp

!Loop on datasets
 do idtset=1,ndtset_alloc

  jdtset=dtsets(idtset)%jdtset ; if(ndtset==0)jdtset=0

  write(message, '(a,a,i6)') ch10,&
&  ' invars1m : enter jdtset=',jdtset
  call wrtout(6,message,'COLL')

! Input default values
  bravais(:)=bravais_(:,0)
  symafm(:)=symafm_(:,0)
  symrel(:,:,:)=symrel_(:,:,:,0)
  tnons(:,:)=tnons_(:,:,0)
  call invars1(bravais,dtsets(idtset),iout,jdtset,lenstr,&
&  mband_upper,mpi_enreg,msym,string,symafm,symrel,tnons,zion_max)

  bravais_(:,idtset)=bravais(:)
  mband_upper_ (idtset)=mband_upper
  symafm_(:,idtset)=symafm(:)
  symrel_(:,:,:,idtset)=symrel(:,:,:)
  tnons_(:,:,idtset)=tnons(:,:)

 end do

 mxmband_upper =maxval(mband_upper_ (1:ndtset_alloc))

 mxnatsph=dtsets(1)%natsph
 mxncenter=dtsets(1)%ncenter
 mxnconeq=dtsets(1)%nconeq
 mxnkptgw=dtsets(1)%nkptgw
 mxnkpt  =dtsets(1)%nkpt
 mxnorb  =dtsets(1)%norb
 mxnqptdm=dtsets(1)%nqptdm
 mxnsppol=dtsets(1)%nsppol
 do ii=1,ndtset_alloc
  mxnatsph=max(dtsets(ii)%natsph,mxnatsph)
  mxncenter=max(dtsets(ii)%ncenter,mxncenter)
  mxnconeq=max(dtsets(ii)%nconeq,mxnconeq)
  mxnkptgw=max(dtsets(ii)%nkptgw,mxnkptgw)
  mxnkpt  =max(dtsets(ii)%nkpt,mxnkpt)
  mxnorb  =max(dtsets(ii)%norb,mxnorb)
  mxnqptdm=max(dtsets(ii)%nqptdm,mxnqptdm)
  mxnsppol=max(dtsets(ii)%nsppol,mxnsppol)
 end do
 deallocate(symafm,symrel,tnons)

!DEBUG
!write(6,*)' invars1m : exit'
!stop
!ENDDEBUG

end subroutine invars1m
!!***
