
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: simple.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"
#include "aca_dlg.h"
#include "aca_widget.h"

#include <error.h>
#include <errno.h>
#include <string.h>

#define Y(a)	(a+y)
#define X(a)	(a+x)

 #define SIMPLE_RESET( _bgr_color_, _header_color_ ) {							\
      y = LINES/2 - yn/2;						\
      x = COLS/2 - xn/2;						\
      aca_border(Y(0),X(0), yn, xn, _bgr_color_);  			\
      clean_box(Y(1),X(1), yn-2, xn-2, _bgr_color_);  		\
      bold;  aca_c(_header_color_);					\
      mvaddstr( Y(0), COLS/2 - strlen(header)/2, header);  		\
      ubold; aca_c(_bgr_color_);					\
      center_addnstr(Y(1), COLS/2, query, xn-4);			\
 }

   int Dlg_YesNo (char *header, char *query, int xn)
   {
      int	y, x, yn, tmp;
      Widget	w[] = {
      	{ TRUE, 0,0,0,0, button_fn, (void *) &def_button[_BUTT_OK],     Wf_DEFAULT, _aca_text_domain },
      	{ TRUE, 0,0,0,0, button_fn, (void *) &def_button[_BUTT_CANCEL], Wf_DEFAULT, _aca_text_domain },			
      	W_NULL
      };
      SessW	s;
   
      init_sessw(&s, 0, FALSE, w, NULL, Sf_NOT_BGR);
      yn  = lines_instr(query) + 4;	
      tmp = size_widgets_progression("wiw", &w[0], 2, &w[1]);

      SIMPLE_RESET(TplC->dlg_bgr, TplC->dlg_header);
      w[1].y = w[0].y = Y(yn-1);					
      
      set_widgets_progression(COLS/2-tmp/2, "wiw", &w[0], 2, &w[1]);	
      W_redraw_session(&s);						
      do {
      	 if (s.key == K_SCREEN_RESIZED) {
      	 	SIMPLE_RESET(TplC->dlg_bgr, TplC->dlg_header); 	
      	 	w[1].y = w[0].y = Y(yn-1);			
      		set_widgets_progression(COLS/2-tmp/2, "wiw", &w[0], 2, &w[1]);	
      		W_redraw_session(&s);						
      	 	continue;
      	 }
         if (run_act_widget(&s) & Wr_BUTTON_PRESS) {
            if (s.actual == 0)	return TRUE;	/* Ok */		
            else		return FALSE; 	/* Cancel */	 
         }
         W_key_to_widgets(&s);		
         W_default_go(&s);
      } while((s.key = get_k()) != KEY_F(10));  
      return FALSE;
   }

   int Dlg_Warning_org (char *header, char *query, int xn, int action, int err)
   {
      int	y, x, yn, tmp;
      Widget	w[] = {
      	{ TRUE, 0,0,0,0, button_fn, (void *) &def_button[_BUTT_CANCEL], Wf_DEFAULT, _aca_text_domain },			
      	W_NULL
      };
      SessW	s;
   
      init_sessw(&s, 0, FALSE, w, NULL, Sf_NOT_BGR);
      yn  = lines_instr(query) + 4;	
      tmp = size_widgets_progression("w", &w[0]);
      if (err) ++yn; 
 
      SIMPLE_RESET(TplC->dlg_warning, TplC->dlg_warning);      
      w[0].y = Y(yn-1);					
      set_widgets_progression(COLS/2-tmp/2, "w", &w[0]);	
      if (err && errno) { bold; center_addnstr(Y(2), COLS/2, strerror(errno), xn-4); ubold; }
      W_redraw_session(&s);						
      do {
      	 if (s.key == K_SCREEN_RESIZED) {
      	 	SIMPLE_RESET(TplC->dlg_warning, TplC->dlg_warning);
      	 	w[0].y = Y(yn-1);					
      		set_widgets_progression(COLS/2-tmp/2, "w", &w[0]);	
		if (err) { bold; center_addnstr(Y(2), COLS/2, strerror(errno), xn-4); ubold; }
      		W_redraw_session(&s);						
      	 	continue;
      	 }
         if (run_act_widget(&s) & Wr_BUTTON_PRESS) 
            	return TRUE; 	/* Cancel */	 
        
         if (action == Warn_draw)
         	return RE_OK;
        
         W_key_to_widgets(&s);		
         W_default_go(&s);
      } while((s.key = get_k()) != KEY_F(10));  
      return TRUE;   
   }

int Error(char *str)
{
	return Dlg_Warning_org (_aca(" Error "), str, (COLS < 50 ? COLS-2 : 50), Warn_std, FALSE);
}

int Error_no(char *str)
{
	return Dlg_Warning_org (_aca(" Error "), str, (COLS < 50 ? COLS-2 : 50), Warn_std, TRUE);
}

int Warning(char *str) 
{
	return Dlg_Warning_org (_aca(" Warning "), str, (COLS < 50 ? COLS-2 : 50), Warn_std, FALSE);
}

int Warning_no(char *str) 
{
	return Dlg_Warning_org (_aca(" Warning "), str, (COLS < 50 ? COLS-2 : 50), Warn_std, TRUE);
}

int ErrorOpen(char *str) 
{
	return Dlg_Warning_org (_aca(" Open error "), str, (COLS < 50 ? COLS-2 : 50), Warn_std, FALSE);
}

int ErrorOpen_no(char *str) 
{
	return Dlg_Warning_org (_aca(" Open error "), str, (COLS < 50 ? COLS-2 : 50), Warn_std, TRUE);
}
