/* -*- C++ -*- */
//=============================================================================
/**
 *  @file    Fault_Detector_Main.cpp
 *
 *  Fault_Detector_Main.cpp,v 1.3 2003/12/22 19:41:19 wilson_d Exp
 *
 *  This file is part of Fault Tolerant CORBA.
 *  This file provides the main routine for a process that
 *  implements the FaultDetectorFactory interface and manages
 *  a set of FaultDetectors.
 *
 *  @author Dale Wilson <wilson_d@ociweb.com>
 */
//=============================================================================

#include <tao/Utils/Server_Main.h>
#include "FT_FaultDetectorFactory_i.h"

int ACE_TMAIN (int argc, ACE_TCHAR *argv[])
{
  TAO::Utils::Server_Main<TAO::FT_FaultDetectorFactory_i> server_main("TAO_FaultDetector");
  return server_main.run(argc, argv);
}

///////////////////////////////////
// Template instantiation for
// inept compilers.

#if defined (ACE_HAS_EXPLICIT_TEMPLATE_INSTANTIATION)
  template class TAO::Utils::Server_Main<TAO::FT_FaultDetectorFactory_i>;
#elif defined (ACE_HAS_TEMPLATE_INSTANTIATION_PRAGMA)
# pragma instantiate TAO::Utils::Server_Main<TAO::FT_FaultDetectorFactory_i>
#endif /* ACE_HAS_EXPLICIT_TEMPLATE_INSTANTIATION */
