/* -*- C++ -*- */
/**
 *  @file EventType.h
 *
 *  EventType.h,v 1.8 2003/10/28 18:34:23 bala Exp
 *
 *  @author Pradeep Gore <pradeep@oomworks.com>
 *
 *
 */

#ifndef TAO_Notify_EVENTTYPE_H
#define TAO_Notify_EVENTTYPE_H

#include /**/ "ace/pre.h"

#include "notify_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "orbsvcs/CosNotificationC.h"

/**
 * @class TAO_Notify_EventType
 *
 * @brief
 *
 * This type is used to compare different event types.
 * It is used by the Event Manager as a key to find subscription lists.
 *
 */
class TAO_Notify_Export TAO_Notify_EventType
{
public:
  /// Constuctor
  TAO_Notify_EventType (void);
  TAO_Notify_EventType (const char* domain_name, const char* type_name);
  TAO_Notify_EventType (const CosNotification::EventType& event_type);
  // Constuctor

  /// Destructor
  ~TAO_Notify_EventType ();

  /// hash value
  u_long hash (void) const;

  /// Assignment from CosNotification::EventType
  TAO_Notify_EventType& operator=(const CosNotification::EventType& event_type);

  /// Assignment operator.
  TAO_Notify_EventType& operator=(const TAO_Notify_EventType& event_type);

  /// == operator
  int operator==(const TAO_Notify_EventType& notify_event_type) const;

  /// != operator
  int operator!=(const TAO_Notify_EventType& notify_event_type) const;

  static TAO_Notify_EventType special (void);
  // Return the special event type.

  CORBA::Boolean is_special (void) const;
  // Is this the special event (accept everything).

  const CosNotification::EventType& native (void) const;
  // Get the type underneath us.

  /// Helper to print contents.
  void dump (void) const;

protected:
  /// Init this object.
  void init_i (const char* domain_name, const char* type_name);

  void recompute_hash (void);
  // Recompute the hash value.

  // = Data Members
  CosNotification::EventType event_type_;
  // The event_type that we're decorating.

  u_long hash_value_;
  // The hash value computed.
};

#if defined (__ACE_INLINE__)
#include "EventType.inl"
#endif /* __ACE_INLINE__ */

#include /**/ "ace/post.h"

#endif /* TAO_Notify_EVENTTYPE_H */
