package GNUACEProjectCreator;

# ************************************************************
# Description   : A GNU Project Creator for ACE
# Author        : Chad Elliott
# Create Date   : 3/13/2002
# ************************************************************

# ************************************************************
# Pragmas
# ************************************************************

use strict;
use File::Basename;

use ProjectCreator;

use vars qw(@ISA);
@ISA = qw(ProjectCreator);

# ************************************************************
# Data Section
# ************************************************************

my(%compscript) = ('ACE_COMPONENTS'     => ['--ace',     '--set'],
                   'TAO_COMPONENTS'     => ['--tao',     '--set'],
                   'ORBSVCS_COMPONENTS' => ['--orbsvcs', '--append'],
                  );

# ************************************************************
# Subroutine Section
# ************************************************************

sub dollar_special {
  #my($self) = shift;
  return 1;
}


sub sort_files {
  #my($self) = shift;
  return 0;
}


sub convert_slashes {
  #my($self) = shift;
  return 0;
}


sub fill_value {
  my($self)  = shift;
  my($name)  = shift;
  my($value) = undef;
  my($names) = $self->{'source_files'};

  if ($name eq 'vpath') {
    my(%vpath) = ();
    foreach my $name (keys %$names) {
      my($comps) = $$names{$name};
      foreach my $key (keys %$comps) {
        foreach my $item (@{$$comps{$key}}) {
          my($dname) = $self->relative(dirname($item));
          if ($dname ne '.' && $dname !~ /^\.\.\//) {
            $vpath{$dname} = 1;
          }
        }
      }
    }
    my($str) = join(':', sort keys %vpath);
    if ($str ne '') {
      $value = 'VPATH = .:' . $str . $self->crlf();
    }
  }
  elsif ($name eq 'comptarget') {
    my($crlf)  = $self->crlf();
    foreach my $name (keys %$names) {
      if (defined $compscript{$name}) {
        if (!defined $value) {
          $value = '';
        }
        $value .= "$crlf.PHONY: $name$crlf" .
                  "$name:$crlf" .
                  "\t\@sh \$(ACE_ROOT)/bin/ace_components $compscript{$name}->[0] $compscript{$name}->[1] '\$($name)'$crlf$crlf" .
                  "compclean:$crlf" .
                  "\t\@sh \$(ACE_ROOT)/bin/ace_components $compscript{$name}->[0] --remove";
      }
    }
  }
  elsif ($name eq 'compclean') {
    foreach my $name (keys %$names) {
      if (defined $compscript{$name}) {
        $value = 'compclean';
        last;
      }
    }
  }
  elsif ($name eq 'libcheck') {
    my($libs) = $self->get_assignment('libs');
    if (defined $libs) {
      my($libpaths) = $self->get_assignment('libpaths');
      if (defined $libpaths) {
        $value = "LIBCHECK = \$(shell for lib in $libs; do for libpath in $libpaths; do full=\"`echo \$\$libpath/lib\$\$lib.* | tr ' ' '\\012' | head -1`\"; if [ -r \$\$full ]; then break; else full=; fi; done; if [ -z \"\$\$full\" ]; then echo \$\$lib; exit; fi; done; echo 1)";
      }
    }
  }
  elsif ($name eq 'tao') {
    my($incs) = $self->get_assignment('includes');
    my($libs) = $self->get_assignment('libpaths');
    if ((defined $incs && $incs =~ /tao/i) ||
        (defined $libs && $libs =~ /tao/i)) {
      $value = 1;
    }
  }

  return $value;
}


sub project_file_name {
  my($self) = shift;
  my($name) = shift;

  if (!defined $name) {
    $name = $self->project_name();
  }

  return $self->get_modified_project_file_name('Makefile' .
                                               ($name eq '' ? '' : ".$name"),
                                               '');
}


sub get_dll_exe_template_input_file {
  #my($self) = shift;
  return 'gnuexe';
}


sub get_dll_template_input_file {
  #my($self) = shift;
  return 'gnudll';
}


sub get_template {
  #my($self) = shift;
  return 'gnu';
}

1;
