// This may look like C, but it's really -*- C++ -*-
// Dynamic_Implementation.h,v 1.11 2005/05/16 15:05:17 jwillemsen Exp

// ============================================================================
//
// = LIBRARY
//    DynamicInterface
//
// = FILENAME
//    Dynamic_Implementation.h
//
// = DESCRIPTION
//    Header file for class TAO_DynamicImplementation.
//
// = AUTHOR
//    Irfan Pyarali <irfan@cs.wustl.edu>
//
// ============================================================================

#ifndef TAO_DYNAMIC_IMPLEMENTATION_H
#define TAO_DYNAMIC_IMPLEMENTATION_H

#include /**/ "ace/pre.h"

#include "dynamicinterface_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/PortableServer/Servant_Base.h"

namespace CORBA
{
  typedef char *RepositoryId;
  typedef String_var RepositoryId_var;

  class ServerRequest;
  typedef ServerRequest *ServerRequest_ptr;
}

class TAO_DynamicInterface_Export TAO_DynamicImplementation
  : public virtual TAO_ServantBase
{
  // = TITLE
  //    Base class for DSI.
  //
  // = DESCRIPTION
  //    It is expected that the <invoke> and <_primary_interface>
  //    methods will be only invoked by the POA in the context of
  //    serving a CORBA request. Invoking this method in other
  //    circumstances may lead to unpredictable results.
public:
  /// The invoke() method receives requests issued to any CORBA object
  /// incarnated by the DSI servant and performs the processing
  /// necessary to execute the request.
  virtual void invoke (CORBA::ServerRequest_ptr request
                       ACE_ENV_ARG_DECL_WITH_DEFAULTS) = 0;

  /// The _primary_interface() method receives an ObjectId value and a
  /// POA_ptr as input parameters and returns a valid RepositoryId
  /// representing the most-derived interface for that oid.
  virtual CORBA::RepositoryId _primary_interface (
      const PortableServer::ObjectId &oid,
      PortableServer::POA_ptr poa
      ACE_ENV_ARG_DECL_WITH_DEFAULTS
    ) = 0;

  /// Local implementation of the CORBA::Object::_is_a method.
  virtual CORBA::Boolean _is_a (const char *logical_type_id
                                ACE_ENV_ARG_DECL_WITH_DEFAULTS);

  /// Returns a CORBA::Object_ptr for the target object.
  CORBA::Object_ptr _this (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS);

  /// Query the Interface Repository for the interface definition.
  virtual CORBA::InterfaceDef_ptr _get_interface (
      ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS
    );

protected:

  /// Return 0.  Should never be used.
  virtual const char *_interface_repository_id (void) const;

  /// Simply returns "this"
  virtual void *_downcast (const char *repository_id);

  /// This is an auxiliary method for _this() and _narrow().
  virtual TAO_Stub *_create_stub (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS);

  /// Turns around and calls invoke.
  virtual void _dispatch (TAO_ServerRequest &request,
                          void *context
                          ACE_ENV_ARG_DECL_WITH_DEFAULTS);

private:
  /// Encapsulates code common to _is_a(), _get_interface() and _create_stub().
  CORBA::RepositoryId get_id_from_primary_interface (
      ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS
    );
};

#include /**/ "ace/post.h"

#endif /* TAO_DYNAMIC_IMPLEMENTATION_H */
