// $Id: client.cpp 78703 2007-06-30 18:43:31Z sowayaa $

#include "TestC.h"
#include "ace/Get_Opt.h"

ACE_RCSID(Server_Leaks, client, "$Id: client.cpp 78703 2007-06-30 18:43:31Z sowayaa $")

const char *ior = "file://test.ior";
int do_shutdown = 0;

int
parse_args (int argc, char *argv[])
{
  ACE_Get_Opt get_opts (argc, argv, "k:x");
  int c;

  while ((c = get_opts ()) != -1)
    switch (c)
      {
      case 'k':
        ior = get_opts.opt_arg ();
        break;

      case 'x':
        do_shutdown = 1;
        break;

      case '?':
      default:
        ACE_ERROR_RETURN ((LM_ERROR,
                           "usage:  %s "
                           "-k <ior> "
                           "-x "
                           "\n",
                           argv [0]),
                          -1);
      }
  // Indicates sucessful parsing of the command line
  return 0;
}

int
ACE_TMAIN(int argc, ACE_TCHAR *argv[])
{
  try
    {
      CORBA::ORB_var orb =
        CORBA::ORB_init (argc, argv);

      if (parse_args (argc, argv) != 0)
        return 1;

      CORBA::Object_var tmp =
        orb->string_to_object(ior);

      Test::Ping_Service_var ping_service =
        Test::Ping_Service::_narrow(tmp.in ());

      if (CORBA::is_nil (ping_service.in ()))
        {
          ACE_ERROR_RETURN ((LM_DEBUG,
                             "Nil process reference <%s>\n",
                             ior),
                            1);
        }

      for (int i = 0; i != 10; ++i)
        {
          ping_service->ping ();
        }

      if (do_shutdown)
        {
          ping_service->shutdown ();
        }

      orb->destroy ();
    }
  catch (const CORBA::Exception& ex)
    {
      ex._tao_print_exception ("Exception caught:");
      return 1;
    }

  return 0;
}
