/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.acgvision.agent.run;

import com.acgvision.agent.action.ServiceActions;
import com.acgvision.core.ws.Control;
import com.acgvision.core.ws.Cpu;
import com.acgvision.core.ws.Job;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class Task implements Serializable, Cloneable {
    private static final Logger logger = Logger.getLogger(Task.class);

    private Job job = null ;
    private Date nextTime = null;
//    private List buffer = new ArrayList();

    /**
     * @return the job
     */
    public Job getJob() {
        return job;
    }

    /**
     * @param job the job to set
     */
    public void setJob(Job job) {
        this.job = job;
    }

    /**
     * @return the nextTime
     */
    public Date getNextTime() {
        return nextTime;
    }

    /**
     * @param nextTime the nextTime to set
     */
    public void setNextTime(Date nextTime) {
        this.nextTime = nextTime;
    }

    public void generateWhen() {
        if (this.job.getSchedule() != null) {
            Long result;
            if (this.getNextTime()==null) {
                result= ServiceActions.getNextTime(this.job.getSchedule());
            }else{
                GregorianCalendar gc =new GregorianCalendar();
                gc.setTime(nextTime);
                result= ServiceActions.getNextTime(this.job.getSchedule(),gc);
            }
            if (result != -1) {
                nextTime = new Date(result);
            }else{
                logger.warn("Cant generate netxtime");
            }
        }
    }

    /**
     * Gets time between now and the next task to happen
     * @return time to wait before checking.
     */
    public Long getTimeToNext(){
        if (this.nextTime==null)return -1L;
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.nextTime);
        GregorianCalendar now = new GregorianCalendar();
        if(logger.isDebugEnabled()) {
            logger.debug("Heure courante" + c.getTime());
        }
        return c.getTimeInMillis() - now.getTimeInMillis();
    }

    public int compareTo(Task o) {
        if (o==null) throw  new java.lang.NullPointerException("Invalid Null Object");
        if (!(o instanceof Task)) throw new ClassCastException("Object must extend Task");
        if(this.getNextTime()==null) return 1;
        return this.getNextTime().compareTo((o).getNextTime());
    }

    public void control(){

    }
    
    @Override
    public Task clone(){
        Task t = new Task();
        t.setJob(job);
        t.setNextTime((Date)nextTime.clone());
        return t;
    }

    public void check(Control control){
        logger.info("Run control");

    }

    public void check(){
        if (job instanceof Cpu){

        }
    }
//
//    /**
//     * @return the buffer
//     */
//    public List getBuffer() {
//        return buffer;
//    }
//
//    /**
//     * @param buffer the buffer to set
//     */
//    public void setBuffer(List buffer) {
//        this.buffer = buffer;
//    }


}