/*
copyright 2003 Alexander Malmberg <alexander@malmberg.org>
*/

#ifndef Clock_h
#define Clock_h

#include <AppKit/NSControl.h>

/*
Times are in minutes since midnight, and a time t should satisfy
0 <= t < 60*24=1440 . Times outside this interval are wrapped to
it.
*/

@class NSColor;

@interface Clock : NSControl
{
	NSColor *faceColor,*frameColor,*marksColor,*handsColor,*arcColor,*secHandColor;

	double handsTime;
	double arcStartTime,arcEndTime;
	float faceTrans;
	BOOL showsArc;
	BOOL showAMPM;
	BOOL shadow;
	BOOL second;
	BOOL easter;

	BOOL alarming;
	int numberType;

	/* Calculated values used when drawing. */
	double radius;
	double base_width;
	NSPoint center;
	NSFont *font;
}

/*
TODO?
-(NSColor *) arcColor;
-(void) setArcColor: (NSColor *)c;*/

-(NSColor *) marksColor;
-(NSColor *) faceColor;
-(NSColor *) frameColor;
-(NSColor *) handsColor;
-(NSColor *) secondHandColor;
-(BOOL) showAMPM;
-(BOOL) shadow;
-(float) faceTransparency;
-(NSFont *)font;
-(void) setFont:(NSFont *)newfont;

-(int) numberType;
-(void) setNumberType: (int)i;
-(void) setMarksColor: (NSColor *)c;
-(void) setFaceColor: (NSColor *)c;
-(void) setFaceTransparency:(float)v;
-(void) setFrameColor: (NSColor *)c;
-(void) setHandsColor: (NSColor *)c;
-(void) setSecondHandColor: (NSColor *)c;
-(void) setShowAMPM:(BOOL)ampm;
-(void) setShadow:(BOOL)sh;
-(void) setSecond:(BOOL)sh;
-(BOOL) second;

-(BOOL) showsArc;
-(void) setShowsArc: (BOOL)s;

-(double) handsTime;
-(void) setHandsTime: (double)time;

-(double) arcStartTime;
-(double) arcEndTime;
-(void) setArcStartTime: (double)time;
-(void) setArcEndTime: (double)time;

@end

#endif

