// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>

#include <QtGui/QStandardItemModel>
#include <QtCore/QCoreApplication>
#include <QtGui/QApplication>

#include <adept/processevents.h>

#ifndef EPT_TOKENMODEL_H
#define EPT_TOKENMODEL_H

namespace adept {

class TokenModel : public QStandardItemModel
{
    bool m_fillPending, m_fillRunning;
    int m_fillLevel, i;

public:
    void rewind() {
        QApplication::setOverrideCursor( QCursor( Qt::BusyCursor ) );
        i = 0;
    }

    void appendToken( ept::Token t )
    {
        QVariant v;
        v.setValue( t );
        
        QStandardItem *current = item( i );
        
        if ( !current ) {
            current = new QStandardItem();
            appendRow( current );
        }
        
        current->setData( v );
        ++ i;
    }

    void end() {
        setRowCount( i );
        QApplication::restoreOverrideCursor();
    }

    template< typename List, typename Validate >
    void fillFrom( List l, const Validate &v ) {
        ++ m_fillLevel;
        int level = m_fillLevel;

        ProcessEvents::restart();
        rewind();
        while ( !l.empty() ) {

            ept::Token t = v.validate( l.head().token() );
            if ( t.valid() )
                appendToken( t );
            l = l.tail();

            /* This can increase level, in which case we immediately
             * drop out of the loop. The recursive call from within
             * processEvents() has re-filled the list, so we have
             * nothing more to do. */
            ProcessEvents::check();
            if ( m_fillLevel > level ) {
                -- m_fillLevel;
                QApplication::restoreOverrideCursor();
                return;
            }
        }
        end();
    }

    TokenModel() : m_fillLevel( 0 ), i( 0 ) {}
};

}

#endif
