// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>

/* TODO this is a "misc" file. Some things here may need to
   eventually move to a better location. */

#include <QtCore/QString>
#include <QtGui/QPixmap>
#include <QtGui/QFont>
#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtGui/QScrollArea>

#include <ept/core/xapian.h>
#include <ept/core/apt.h>
#include <ept/core/apt/action.h>

#include <kiconloader.h>
#include <kstandarddirs.h>
#include <klocale.h>

#ifndef ADEPT_UTIL_H
#define ADEPT_UTIL_H

Q_DECLARE_METATYPE(ept::Token)

namespace adept {

using namespace ept::core;

inline std::string s8( QString s ) {
    return std::string( s.toUtf8() );
}

inline QString u8( std::string s ) {
    return QString::fromUtf8( s.c_str() );
}

inline QString l8bit( std::string s ) {
    return QString::fromLocal8Bit( s.c_str() );
}

inline QLabel *setupErrorWidget( QWidget *parent )
{
    QScrollArea *scroll = new QScrollArea( parent );
    QLabel *l = new QLabel();
    l->setWordWrap( true );
    l->setTextInteractionFlags( Qt::TextSelectableByMouse );
    scroll->setWidget( l );
    scroll->setWidgetResizable( true );
    scroll->setAlignment( Qt::AlignCenter );
    scroll->setFrameStyle( QFrame::NoFrame );
    return l;
}

inline QString describeExcept( std::string err )
{
    QString ret = "<p align=left style=\"font-family: monospace\">";
    ret += u8( err );
    ret += "</p>";
    ret.replace( "\n", "<br>" );
    ret.replace( "    ", "&nbsp;&nbsp;&nbsp;&nbsp;" );
    return ret;
}

inline QString describeExcept( std::exception &e ) {
    return describeExcept( e.what() );
}

inline QString describeExcept( Xapian::Error &e ) {
    return describeExcept( e.get_msg() );
}

inline QPixmap scaledIcon( const char *name, int size ) {
    return KIconLoader::global()->loadIcon(
        KGlobal::dirs()->findResource( "appdata", QString( name ) + ".svg" ),
        KIconLoader::NoGroup, size );
}

inline static void adjustFontSize( QWidget *w, int off ) {
    QFont f = w->font();
    f.setPointSize( f.pointSize() + off ); // a bit smaller font...
    w->setFont( f );
    w->updateGeometry();
}

inline QString statusString( PackageState s ) {
    if ( s.nowBroken() )
        return i18n( "broken" );
    if ( s.hold() )
        return i18n( "held" );
    if ( s.upgradable() )
        return i18n( "upgradable" );
    if ( s.installed() )
        return i18n( "installed" );
    return i18n( "not installed" );
}

inline QString actionString( PackageState s ) {
    if ( s.upgrade() )
        return i18n( "upgrade" );
    if ( s.install() )
        return i18n( "install" );
    if ( s.remove() )
        return i18n( "remove" );
    return i18n( "unknown" );
}

inline QColor statusColor( PackageState s ) {
    if ( s.nowBroken() )
        return Qt::red;
    if ( s.hold() )
        return Qt::darkRed;
    if ( s.upgradable() )
        return Qt::darkYellow;
    if ( s.installed() )
        return Qt::darkGreen;
    return Qt::blue;
}

inline QColor actionColor( PackageState s ) {
    if ( s.upgrade() )
        return Qt::darkYellow;
    if ( s.install() )
        return Qt::darkGreen;
    if ( s.remove() )
        return Qt::darkRed;
    return Qt::red;
}

inline QPixmap statusIcon( PackageState s, int size ) {
    if ( s.upgrade() )
        return scaledIcon( "upgrade", size );
    if ( s.install() )
        return scaledIcon( "install", size );
    if ( s.remove() )
        return scaledIcon( "remove", size );
    if ( s.upgradable() )
        return scaledIcon( "upgradable", size );
    if ( !s.installed() )
        return scaledIcon( "notinstalled", size );
    if ( s.installed() )
        return scaledIcon( "installed", size );
    return QPixmap();
}

inline QString formatLongDescription( QString l )
{
    // matches list item: spaces+ then - or *; it extends to a newline followed
    // by spaces+ then - or * again (next item), *or* a newline that's not
    // followed by 2 or more spaces, or end of string. Complex, duh?
    QRegExp rx( u8( "\n +[-*] (.*)(\n(?!  +)|\n(?= +[-*])|$)" ) );
    rx.setMinimal( true );
    QString old;
    while ( old != l ) {
        old = l;
        l.replace( rx, u8( "\n<li>\\1 \\2</li>\n" ) );
    }
    rx = QRegExp( u8( "((<li>.*</li>\n)+)" ) );
    l.replace( rx, u8( "<ul>\\1</ul>" ) );
    rx = QRegExp( u8( "\\n[ ]*\\.?\\n" ) );
    l.replace( rx, u8( "</p><p align=justify>" ) );
    return QString( "<p align=justify>" ) + l + u8( "</p>" );
}

}

#endif
