#include "AdunKernel/AdFrameworkFunctions.h"


NSError* AdKnownExceptionError(int code, NSString* localizedDescription,
	NSString* detailedDescription,
	NSString* recoverySuggestion)
{
	NSMutableDictionary* errorInfo;
	NSError* error;

	errorInfo = [NSMutableDictionary dictionary];

	if(localizedDescription != nil)
		[errorInfo setObject: localizedDescription 
			forKey: NSLocalizedDescriptionKey];

	if(detailedDescription != nil)
		[errorInfo setObject: detailedDescription 
			forKey: @"AdDetailedDescriptionKey"];

	if(recoverySuggestion != nil)		
		[errorInfo setObject: recoverySuggestion
			forKey: @"NSRecoverySuggestionKey"];

	if([errorInfo count] == 0)
		errorInfo = nil;

	error = [NSError errorWithDomain: @"AdKernelErrorDomain"
			code: code
			userInfo: errorInfo];

	return error;		
}

