/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef AD_DELEGATION
#define AD_DELEGATION
#include <Foundation/Foundation.h>

/**
AdDelegation is implemented by classes that use delegation
\ingroup Protocols
*/

@protocol AdDelegation
/**
Set the delegate of the object to \e delegate
*/
- (void) setDelegate: (id) delegate;
/**
Returns the current delegate
*/
- (id) delegate;
@end

/**
AdDataSourceDelegation is adopted by classes that use a data source to
provide them with data
\ingroup Protocols
*/

@protocol AdDataSourceDelegation

/**
Sets the data source to be used to \e dataSource. The data source is expected to
implement at least some of the data source delegate methods defined by the object.
The dataSource object is not retained.
*/

- (void) setDataSource: (id) anObject;

/**
Returns the data source being used by the object
*/

- (id) dataSource;

/**
Reloads the data provided by data source
*/

- (void) reloadData;

@end

#endif
