/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef ADUN_BOUNDARYIMPLEMENTOR
#define ADUN_BOUNDARYIMPLEMENTOR

#include <stdio.h>
#include <stdlib.h>
#include "AdunKernel/AdunObject.h"


/**
AdBoundaryImplementor is the base class for objects that apply boundary contraints to 
a system. Such objects usually (always?) form part of a polymorphic composition that
makes up a ForceField object.
\ingroup Inter
**/

@interface AdBoundaryImplementor: AdObject <AdAbstractFactory>
/** Method applies the boundary conditions to the current system
**/
- (void) applyBoundaryConditions;
@end

#endif
