#include "ULFramework/ULFileSystemSimulationStorage.h"

@implementation ULFileSystemSimulationStorage

- (void) _checkStorage
{
	BOOL isDirectory;

	fileManager = [NSFileManager defaultManager];
	
	if(accessError != nil)
	{
		[accessError release];
		accessError = nil;
	}	
	
	if(![fileManager fileExistsAtPath: storagePath isDirectory: &isDirectory])
		accessError = [NSError errorWithDomain: @"ULErrorDomain"
				code: 10
				userInfo: [NSDictionary dictionaryWithObjectsAndKeys: 
						@"Data Storage not present", 
						NSLocalizedDescriptionKey,
						nil]];
	
	//check its a results dir
	
	if(!isDirectory)
		accessError = [NSError errorWithDomain: @"ULErrorDomain"
				code: 10
				userInfo: [NSDictionary dictionaryWithObjectsAndKeys: 
						@"Data Storage is not a directory", 
						NSLocalizedDescriptionKey,
						nil]];

	//check it contains the required files

	if(![fileManager isReadableFileAtPath: [storagePath stringByAppendingPathComponent: @"system.ad"]])
		accessError = [NSError errorWithDomain: @"ULErrorDomain"
				code: 10
				userInfo: [NSDictionary dictionaryWithObjectsAndKeys: 
						@"Simulation data not readable or not present", 
						NSLocalizedDescriptionKey,
						nil]];
	if(accessError != nil)				
	{
		[accessError retain];					
		isAccessible = NO;
	}
	else
		isAccessible = YES;
}

- (id) initForReadingSimulationDataAtPath: (id) path error: (NSError**) anError;
{
	if(self = [super init])
	{
		fileManager = [NSFileManager defaultManager];

		if(anError != NULL)
			*anError = accessError;

		isAccessible = YES;
		isTemporary = NO;
		storagePath = [path retain];
		[self _checkStorage];
	}

	return self;
}

- (id) initForReadingSimulationDataAtPath: (NSString*) path
{
	return [self initForReadingSimulationDataAtPath: path
			error: NULL];
}

- (id) initStorageForSimulationAtPath: (NSString*) path
{
	[[NSFileManager defaultManager]
		createDirectoryAtPath:  path
		attributes: nil];
	return [self initForReadingSimulationDataAtPath: path	
			error: NULL];	
}

- (BOOL) destroyStoredData
{
	int retVal;

	if(isAccessible)
	{
		retVal = [fileManager removeFileAtPath: storagePath
				handler: nil];
		//If its deleted set accessError and isAccessible
		//using _checkStorage
		if(retVal)
			[self _checkStorage];
	}
	else
		retVal = NO;
		
	return retVal;
}

- (void) dealloc
{
	if(isTemporary)
		if(![self destroyStoredData])
			NSWarnLog(@"Could not destory temporary storage at %@",
					storagePath);
					
	[storagePath release];
	[accessError release];
}

- (NSData*) trajectoryData
{
	return [fileManager contentsAtPath:
		 [storagePath stringByAppendingPathComponent: @"trajectory.ad"]];
}

- (NSData*) energyData
{
 	return [fileManager contentsAtPath: 
		[storagePath stringByAppendingPathComponent: @"energy.ad"]];
}

- (NSData*) systemData
{
 	return [fileManager contentsAtPath: 
		[storagePath stringByAppendingPathComponent: @"system.ad"]];
}

- (NSData*) restartData
{
 	return [fileManager contentsAtPath: 
		[storagePath stringByAppendingPathComponent: @"system.ad"]];
}

- (BOOL) isAccessible
{
	[self _checkStorage];
	return isAccessible;
}

- (NSError*) accessError
{
	return accessError;
}

- (NSString*) storagePath
{
	return [[storagePath retain] autorelease];
}

- (BOOL) isTemporary
{
	return isTemporary;
}

- (void) setIsTemporary: (BOOL) value
{
	isTemporary = value;
}

- (id) initWithCoder: (NSCoder*) decoder
{
	if([decoder allowsKeyedCoding])
	{
		storagePath = [decoder decodeObjectForKey: @"StoragePath"];
		[storagePath retain];
		[self _checkStorage];
	}
	else
		NSWarnLog(@"ULFileSystemSimulationStorage does not support nonkeyed encoding");

	return self;
}

- (void) encodeWithCoder: (NSCoder*) encoder
{
	if([encoder allowsKeyedCoding])
	{
		[encoder encodeObject: storagePath
			forKey: @"StoragePath"];
	}
	else
		NSWarnLog(@"ULFileSystemSimulationStorage does not support nonkeyed encoding");
}

@end
