/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ADUN_CORE_ADDITIONS_
#define _ADUN_CORE_ADDITIONS_

/**
\defgroup core AdunCore Program
\ingroup Kernel

AdunCore is a simulation program built on top of the AdunKernel Framework. 
At its most basic a simulator is a program that generates configurations of a set of elements (\e system).
Usually the configuration generation process requires knowledge of the systems energy and/or the energy gradient i.e. the force,
which are calculated using a <em>force field</em>.

\section run Running the Program (Command Line)

Usage: AdunCore -Template \e templateFile [options]

All options must be specified as option value pairs

- -Template 
	- A valid Adun template file which defines the structure of the simulator.
	This option is required. See \ref template for more.
- -ExternalObjects
	- An dictionary in gnustep plist format of filename/templatename pairs where the referenced files containarchived objects. 
	  e.g. '{object1="file1Name", object2="file2Name")'
- -SimulationOutputDir
	- Directory where simulation data will be stored.
	- Default value: SimulationOutput
- -ControllerOutputDir
	- Directory where controller data will be stored.
	- Default value: ControllerOutput
- -CreateLogFiles
	- If YES log files are created otherwise they are not i.e. all output is written to the terminal.
	- Default value: YES
- -LogFile
	- File where the programs output will be written. The location will change if RedirectOutput is YES.
	- Default value: AdunCore.log.
- -ErrorFile
	- File where program errors and warning will be written. The location will change if RedirectOutput is YES.
	- Default value: AdunCore.error.
- -RedirectOutput
	- If YES then log files will be moved to the simulation output directory when it is created.
	- Default value: YES
- -RunInteractive
	- If YES then the simulation loop is spawned as a separate thread. The main thread
	then enters a run loop and can serve external requests. If NO then no interaction is possible
	with the simulation.
	- Default value: NO
- -ConnectToAdServer
	- If YES the simulation connects and registers its existance with a local AdServer daemon. 
	This allows the simulation to be viewed from the Adun GUI.
	Depending on the value of the RunInteractive option you may also be able to control the simulation
	from the graphical interface.
	- Default value: NO
	
Users can provided default values for every option using the gnustep defaults system. 
To specify a default value for an option type the following at the command line -

defaults write AdunCore \e optionName \e optionValue.

The default value is recorded until it is deleted or overwritten by the user. 
If an option is not provided on the command line, AdunCore will search for a user supplied default value before using
its standard default value.

\section adunDir The adun Directory

The adun directory is where AdunCore controllers, extension plugins and other program files are stored. 
It is created by the program when it is first run by a given user. 
The default location for the directory is /home/<em>username</em>/adun. 
Controller plugins must be placed in ~adun/Plugins/Controllers while extension plugins are located in ~adun/Plugins/Extensions. 
By default simulation log files are stored in the adun directory.

\section template Adun Template Files

<em> Description forthcoming </em>

\section Controllers

The behaviour of AdunCore can be customised by loading plugins called \e controllers
which can manipulate the simulator structure, create & destroy framework classes,
modify the simulators initialisation procedure etc. 
Hence they can be used to create complex simulation protocols.
The interface for controllers is defined by the AdController protocol. 
The AdController class provides a basic implementation of this protocol which can be subclassed
by developers to quickly create new controllers.

\section Interaction

<em> Description forthcoming </em>

*/

/**
\defgroup coreClasses Classes
The AdunCore classes provide program functionality but are compiled as part of the AdunKernel framework for convience. 
\ingroup core
*/

/**
\defgroup coreProtocols Protocols
\ingroup core
*/

/**
\defgroup coreDataTypes DataTypes
\ingroup core
*/

/**
\defgroup coreConstants Constants
\ingroup core
*/

/**
\ingroup coreConstants
The error domain for the AdunCore program. 
See AdCoreErrorCodes for the error codes that can come from this domain. 
\note An error with this domain is associated with termination of the program.
*/
#define AdunCoreErrorDomain @"AdunCore.ErrorDomain"

/**
\ingroup coreDataTypes
Defines the error codes for the AdunCoreErrorDomain. Errors from this domain cause the program to exit and
hence the code of the error will also be the termination code of the program.
An AdCoreControllerError or AdCoreTemplateProcessingError can be due to an underlying AdKernelError or
an exception from a AdunKernel framework object.
*/
typedef enum
{
	AdCoreUnexpectedExceptionError = 0, 	/**< An exception rose to the top level of the program */
	AdCoreControllerError = 1, 	/**< Controller exited for some reason */
	AdCoreFatalCommandError = 2, 	/**< A core command raised an exception */
	AdCoreConnectionError = 3,	 /**< Unable to connect to server in server run mode*/
	AdCoreDirectoryStructureError = 4, 	/**< Program directory structure corrupted and unfixable*/
	AdCoreLogFileError = 5,		/**< Unable to create program log files*/
	AdCoreArgumentsError = 6,	/**< Invalid program arguements*/
	AdCoreInvalidTemplateError = 7,		/**< Invalid template */
	AdCoreTemplateProcessingError = 8,	/**< Template could not be processed for some reason. */
	AdCoreCommandError = 9,		/**< An error associated with execution of a command*/
	AdCoreSimulationDataStorageError = 10		/**< An error associated with accessing simulation data*/
}
AdCoreErrorCodes;

#endif
