// Copyright (c) 2013, Thomas Goyne <plorkyeran@aegisub.org>
//
// Permission to use, copy, modify, and distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
// Aegisub Project http://www.aegisub.org/

/// @file text_file_writer.h
/// @see text_file_writer.cpp
/// @ingroup utility
///

#include <memory>
#include <string>

#include <libaegisub/fs_fwd.h>

namespace agi {
	namespace charset { class IconvWrapper; }
	namespace io { class Save; }
}

class TextFileWriter {
	std::unique_ptr<agi::io::Save> file;
	std::unique_ptr<agi::charset::IconvWrapper> conv;

public:
	TextFileWriter(agi::fs::path const& filename, std::string encoding="");
	~TextFileWriter();

	void WriteLineToFile(std::string const& line, bool addLineBreak=true) { WriteLineToFile(std::string(line), addLineBreak); }
	void WriteLineToFile(std::string&& line, bool addLineBreak=true);
};
