/****************** Start of $RCSfile: netutils.h,v $  ****************
*
* $Source: /home/alb/afbackup/afbackup-3.3.7/RCS/netutils.h,v $
* $Id: netutils.h,v 1.2 2002/02/27 10:17:11 alb Exp alb $
* $Date: 2002/02/27 10:17:11 $
* $Author: alb $
*
*
******* description ***********************************************
*
*
*
*******************************************************************/

#include <lconf.h>

#ifndef __NETUTILS_H
#define	__NETUTILS_H	__NETUTILS_H

#include <stdio.h>
#include <sys/types.h>
#ifdef	HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <sys/socket.h>
#include <netinet/in.h>

#include <x_types.h>
#include <genutils.h>
#include <sysutils.h>

#define	TCPMUX_INETD_STARTED		1
#define	TCPMUX_STOP_ON_LAST_CLOSE	( TCPMUX_INETD_STARTED << 1 )

typedef	struct _tcpmux_input_done_actions {
  Flag	*conns_to_close;
  Flag	have_conns_to_close;
} TcpMuxCallbDoneActions;

typedef	struct _node_address_space {
  char	just_space[256];
}	nodeaddr;

#ifdef	__cplusplus
extern	"C"	{
#endif

extern	int	open_tcpip_conn(UChar *, UChar *, Int32);
extern	int	open_tcpip_conn_forced(UChar *, UChar *, Int32, Int32);
extern	int	get_tcp_portnum(UChar *);
extern	Int8	same_host(UChar *, UChar *);
extern	Int32	set_ip_throughput(int);
extern	Int32	set_tcp_nodelay(int, Flag);
extern	Int32	set_socket_keepalive(int);
extern	UChar	*get_connected_peername(int);
extern	UChar	*get_hostnamestr(struct sockaddr *);
extern	UChar	*get_my_off_hn();
extern	Int32	tcp_mux_service(int, UChar *,
			void *(*)(int, Int32, void *, struct sockaddr *,
					void *, TcpMuxCallbDoneActions *),
			Int32 (*)(int, void *, Int32, void *,
					TcpMuxCallbDoneActions *, void *),
			Int32 (*)(int, void *, Int32, void *, void *),
			Int32, void (*)(int, void *, void *), Uns32, void *);
extern	Int32	tcp_mux_long_io(void *, int, UChar *, Int32, Int32,
					Int32 (*)(int, UChar *, Int32));
#define	tcp_mux_long_write(tmstat, fd, data, num)	\
		tcp_mux_long_io(tmstat, fd, data, num, 1, write_forced)
#define	tcp_mux_long_read(tmstat, fd, data, num)	\
		tcp_mux_long_io(tmstat, fd, data, num, 0, read_forced)

#ifdef	__cplusplus
}
#endif

#endif	/* ! defined(__NETUTILS_H) */

