# ---------------------------------------------------------------------------
# - MTH0103.als                                                             -
# - afnix:mth module algebra test unit                                      -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2011 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   real sparse object test unit
# @author amaury darsch

# get the module
interp:library "afnix-mth"

# create an empty sparse object
const rs (afnix:mth:Rsparse 2)

# check predicate and name
assert true (afnix:mth:rsi-p rs)
assert true (afnix:mth:r-sparse-p rs)
assert "Rsparse" (rs:repr)

# check length and add
assert 0 (rs:length)
assert 0 (rs:set 1 1.0)
assert 1 (rs:length)

# check index and value
assert 1   (rs:get-index 0)
assert 1.0 (rs:get-value 0)

# add another value
assert 1 (rs:set 0 2.0)
assert 2 (rs:length)
# check index and value
assert 0   (rs:get-index 1)
assert 2.0 (rs:get-value 1)

# change existing value
assert 0 (rs:set 1 3.0)
assert 2 (rs:length)
# check index and value
assert 1   (rs:get-index 0)
assert 3.0 (rs:get-value 0)

# set the matrix parameters
const size 100
const rmax 100.0

# create a random matrix
const rm (afnix:mth:get-random-r-matrix size true rmax)
assert size (rm:get-row-size)
assert size (rm:get-col-size)

# check the row sparse object
loop (trans row 0) (< row size) (row:++) {
  # create the rso object
  trans rso (rm:to-row-sparse row)
  # check type
  assert true (afnix:mth:rsi-p rso)
  assert true (afnix:mth:r-sparse-p rso)
  # check content
  trans len (rso:length)
  loop (trans pos 0) (< pos len) (pos:++) {
    trans col (rso:get-index pos)
    trans val (rso:get-value pos)
    assert val (rm:get row col)
  }
}
