// ---------------------------------------------------------------------------
// - Rco.hpp                                                                 -
// - afnix:csm module - registered cloud object class definition             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2012 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_RCO_HPP
#define  AFNIX_RCO_HPP

#ifndef  AFNIX_STRING_HPP
#include "String.hpp"
#endif

namespace afnix {

  /// The Rco class is a registered cloud object. An object is registed as
  /// soon as its registration id is set. If the registration id is unset
  /// the object is unregistered or anonymous. The registration id can be
  /// anything as long as as it is understood by the implementation that
  /// such registration is to be interpreted somewhere else.
  /// @author amaury darsch

  class Rco : public virtual Object {
  protected:
    /// the registration id
    String  d_rid;
    /// the registered object
    Object* p_rco;

  public:
    /// create nil object
    Rco (void);

    /// create an anonymous object
    /// @param rco the object to regsiter 
    Rco (Object* rco);

    /// create a registered object
    /// @param rid the registration id
    /// @param rco the registrered object
    Rco (const String& rid, Object* rco);

    /// copy construct this registered object
    /// @param that the object to copy
    Rco (const Rco& that);

    /// destroy this registered object
    ~Rco (void);

    /// @return the class name
    String repr (void) const;

    /// @return a clone of this object
    Object* clone (void) const;

    /// assign a member object to this one
    /// @param that the object to assign
    Rco& operator = (const Rco& that);

    /// compare a rco with another one
    bool operator == (const Rco& rco) const;

    /// compare a rco with another one
    bool operator != (const Rco& rco) const;

    /// @return the registration id
    virtual String getrid (void) const;

    /// @return the registered object
    virtual Object* getobj (void) const;

  public:
    /// create a object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// operate this object with another object
    /// @param type   the operator type
    /// @param object the operand object
    Object* oper (t_oper type, Object* object);

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
