/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_COLOR_TEST_H
#define __GCS_COLOR_TEST_H

#include "../gcs-color.h"
#include <stdexcept>
#include <cppunit/extensions/HelperMacros.h>

namespace gcs
{
    namespace Test
    {
        namespace Color
        {
            class ConstructionSuite : public CppUnit::TestFixture
            {
                CPPUNIT_TEST_SUITE(ConstructionSuite);
                CPPUNIT_TEST(testDefaultConstructor);
                CPPUNIT_TEST(testHexConstructor);
                CPPUNIT_TEST(testRgbConstructor);
                CPPUNIT_TEST(testGdkConstructor);
                CPPUNIT_TEST(testCopyConstructor);
                CPPUNIT_TEST(testDestructor);
                CPPUNIT_TEST_SUITE_END();

                protected:
                void testDefaultConstructor(void);
                void testHexConstructor(void);
                void testRgbConstructor(void);
                void testGdkConstructor(void);
                void testCopyConstructor(void);
                void testDestructor(void);
            };

            class StaticFunctions : public CppUnit::TestFixture
            {
                CPPUNIT_TEST_SUITE(StaticFunctions);
                CPPUNIT_TEST(testRgbToHex);
                CPPUNIT_TEST(testRgbToHsv);
                CPPUNIT_TEST(testRgbAsP);
                CPPUNIT_TEST_SUITE_END();

                protected:
                    void testRgbToHex(void);
                    void testRgbToHsv(void);
                    void testRgbAsP(void);
            };

            class GetsAndSets : public CppUnit::TestFixture
            {
                CPPUNIT_TEST_SUITE(GetsAndSets);
                CPPUNIT_TEST(testSetRgb);
                CPPUNIT_TEST(testSetHex);
                CPPUNIT_TEST(testSetRed);
                CPPUNIT_TEST(testSetGreen);
                CPPUNIT_TEST(testSetBlue);
                CPPUNIT_TEST(testSetHue);
                CPPUNIT_TEST(testSetSaturation);
                CPPUNIT_TEST(testSetValue);
                CPPUNIT_TEST_SUITE_END();

                protected:
                void testSetRgb(void);
                void testSetHex(void);
                void testSetRed(void);
                void testSetGreen(void);
                void testSetBlue(void);
                void testSetHue(void);
                void testSetSaturation(void);
                void testSetValue(void);
            };

        } // namespace Color
    } // namespace Test
} // namespace gcs

#endif // __GCS_COLOR_TEST_H
