/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#include <gtkmm/stock.h>
#include "gcs-save-chooser.h"
#include "gcs-conf.h"
#include "gcs-debug.h"

namespace gcs
{
    namespace Dialogs
    {

        SaveChooser::SaveChooser(Glib::ustring title) :
            Gtk::FileChooserDialog(title, Gtk::FILE_CHOOSER_ACTION_SAVE)
        {
            set_current_folder_uri(Conf::get_last_save_dir());

            m_cancelButton = add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
            m_okButton = add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);
            set_do_overwrite_confirmation();
            m_okButton->can_default();

            // update the last saved location in gconf whenever the user
            // presses the "OK" button on the SaveChooser dialog
            m_okButton->signal_clicked().connect(sigc::mem_fun(*this,
                        &SaveChooser::update_save_dir));
        }


        void SaveChooser::update_save_dir(void)
        {
            Conf::set_last_save_dir(get_current_folder_uri());
        }

    } // namespace Dialogs

} // namespace gcs
