/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_HISTORY_H
#define __GCS_HISTORY_H

#include <stack>
#include "gcs-debug.h"

namespace gcs
{

    template <class T> class HistoryNavigation
    {
        public:
            HistoryNavigation(void) : back_stack(), forward_stack(), current(),
                                      initialized(false) {}
            virtual ~HistoryNavigation(void) {}

            typedef T value_type;

            value_type go_back(void)
            {
                forward_stack.push(current);
                current = back_stack.top();
                debug("Set current to: ", current);
                back_stack.pop();
                return current;
            }

            value_type go_forward(void)
            {
                back_stack.push(current);
                current = forward_stack.top();
                debug("Set current to: ", current);
                forward_stack.pop();
                return current;
            }

            void add(value_type item)
            {
                if (item != current)
                {
                    if (initialized)
                    {
                        debug("pushing onto stack: ", current);
                        back_stack.push(current);
                    }
                    debug("setting current to ", item);
                    current = item;
                    // clear forward stack, since we're adding a new 'fork' for the
                    // history
                    while (!forward_stack.empty())
                        forward_stack.pop();
                    initialized = true;
                }
            }

            bool has_back(void) const { return !(back_stack.empty()); }
            bool has_forward(void) const { return !(forward_stack.empty()); }

            const value_type& get_last(void) { return back_stack.top(); }
            const value_type& get_next(void) { return forward_stack.top(); }

            friend std::ostream& operator<<(std::ostream& out, const HistoryNavigation& hist)
            {
                return out << "History: " << hist.back_stack.size() << " back, "
                    << hist.forward_stack.size() << " forward" << std::endl;
            }

        private:
            std::stack<T> back_stack;
            std::stack<T> forward_stack;
            T current;
            bool initialized;
    };

} // namespace gcs

#endif // __GCS_HISTORY_H
