#include "CalendarDomain.h"
//#include "CalendarEvent.h"
#include "CalendarUser.h"

#include "CalendarDomain+CalendarUser.h"

@interface CalendarDomain (Private)
- (void) _initializeDomain;
@end

@implementation CalendarDomain (Private)
- (void) _initializeDomain
{
	NSLog(@"Domain '%@' is initialized.", _name);
}
@end


@implementation CalendarDomain

static NSMapTable *__domainMap;

+ (void) initialize
{
	__domainMap = NSCreateMapTable(
			NSNonRetainedObjectMapKeyCallBacks,
			NSNonRetainedObjectMapValueCallBacks,
			1);
}

+ (NSArray *) allCalendarDomains
{
	return NSAllMapTableValues(__domainMap);
}

+ (NSArray *) allCalendarDomainNames
{
	return NSAllMapTableKeys(__domainMap);
}

+ (CalendarDomain *) calendarDomainNamed:(NSString *)name
{
	return NSMapGet(__domainMap, name);
}

+ (CalendarDomain *) calendarDomainWithName:(NSString *)name
{
	id domain = NSMapGet(__domainMap, name);
	if (domain == nil)
	{
		domain = [[self alloc] initWithDomainName:name];
	}
	return domain;
}

- (id) initWithDomainName:(NSString *)name
{
	id domain = NSMapGet(__domainMap, name);
	if (domain != nil)
	{
		AUTORELEASE(self);
		return domain;
	}

	ASSIGN(_name, name);
	NSMapInsert(__domainMap, name, self);

	_userDict = [[NSMutableDictionary alloc] init];
	__root = nil;

	[self _initializeDomain];

	return self;
}

- (void) dealloc
{
	if (_name)
	{
		NSMapRemove(__domainMap, _name);
	}

	RELEASE(_name);
	RELEASE(_userDict);

	[super dealloc];
}

- (NSString *) name
{
	return _name;
}

- (CalendarUser *) owner
{
	return __root;
}

/*
- (NSArray *) allUsers
{
	return [_userDict allValues];
}

- (BOOL) calendarUser:(CalendarUser *)user
canModifyCalendarPrimitive:(id <CalendarPrimitive>)obj
{
	if (user == [obj owner] || __root == user)
	{
		return YES;
	}

	return NO;
}

- (BOOL) calendarUser:(CalendarUser *)user
canAppendCalendarPrimitive:(id <CalendarPrimitive>)obj
{
	if (user == [obj owner] || __root == user)
	{
		return YES;
	}

	return NO;
}

- (BOOL) calendarUser:(CalendarUser *)user
canReadCalendarPrimitive:(id <CalendarPrimitive>)obj
{
	if (user == [obj owner] || __root == user)
	{
		return YES;
	}

	return NO;
}
*/

/*
- (CalendarUser *) requestCalendarUserWithName:(NSString *)name
{
	return [_userDict objectForKey:name];
}

- (CalendarEvent *) requestCalendarEventForCalendarUser:(CalendarUser *)user
									  calendarEventName:(NSString *)name
												  group:(CalendarGroup *)group
{

//NYI

	return nil;
}
*/

/* called by an CalendarEvent */
/*
- (void) setCalendarEvent:(CalendarEvent *)event
{
	CalendarUser *user;
	CalendarEvent *ev;
	NSEnumerator *en;

	user = [_userDict objectForKey:[[event owner] name]];
	if (user == nil)
	{
		NSLog(@"User %@ doesn't exist.", [[event owner] name]);
		return;
	}

	[user setCalendarEvent:event];
}

- (NSString *) description
{
	return [NSString stringWithFormat:@"Agendum:%@ contains %d user(s).", _name,
		[_userDict count]];
}
*/

#if 0
- (void) setCalendarUser:(CalendarUser *)user
{
	CalendarUser *oldUser;

	if (user == nil || [user name] == nil)
	{
		return;
	}

	oldUser = [_userDict objecForKey:[user name]];
	/* user already exists */
	if (oldUser == user)
	{
		return;
	}

	/* set existing user */
	if (oldUser != nil)
	{
		id info;
		info = [user password];
		if (info != nil)
		{
			[oldUser setPassword:(NSString *)info];
		}
		info = [user userInfo];
		if (info != nil)
		{
			[oldUser setUserInfo:(NSDictionary *)info];
		}
		info = [user timeZone];
		if (info != nil)
		{
			[oldUser setTimeZone:(NSTimeZone *)info];
		}
		return;
	}

	/* user is new set root and/or add to user dict */

	user = [self calendarUser:user];

	if (__root == nil)
	{
		NSLog(@"User %@ becomes root on %@", [user name], _name);
		__root = user;
	}

	[_userDict setObject:user forKey:[user name]];

}
#endif

/*
- (BOOL) containsCalendarUserWithName:(NSString *)name
{
	if ([_userDict objectForKey:name] != nil)
	{
		return YES;
	}
	return NO;
}

- (void) removeCalendarUser:(CalendarUser *) user
{
	if (__root == user)
	{
		__root = nil;
	}

	[_userDict removeObjectforKey:[user name]];
}

- (CalendarUser *) calendarUser:(CalendarUser *)user
{
	if ([user calendarDomain] != self)
	{
		return [_userDict objectForKey:[user name]];
	}
	return user;
}

- (CalendarUser *) calendarUserWithName:(NSString *)name
{
	return [_userDict objectForKey:name];
}
*/

@end

@implementation CalendarDomain (CalendarUser)
- (CalendarUser *) authenticateCalendarUser:(CalendarUser *)newUser
{
	NSString *newUserName = [newUser name];
	id oldUser = [_userDict objectForKey:newUserName];
	if (oldUser != nil)
	{
		if ([[oldUser password] isEqualToString:[newUser password]])
		{
			return oldUser;
		}
		
		return nil;
	}

	if (__root != nil)
	{
		return nil;
	}
	/* no root, set the new user root */

	[_userDict setObject:newUser forKey:newUserName];
	__root = newUser;

	NSLog(@"register root %@",_userDict);

	return newUser;
}

@end
