#ifndef _WEAPON_H
#define _WEAPON_H

#include "strings.h"
#include "moveable.h"
#include "builder.h"

enum hands {One_Handed, Two_Handed};

class Weapon : public Moveable
{
public:

   Weapon(char *the_name, char *the_area);
   virtual ~Weapon();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int      set_weapon_class(char *new_class);
   char     *get_weapon_class(void);

   void     set_damage(int new_damage);
   int      get_damage(void);
 
   void     set_wield_type(hands the_type);
   hands    get_wield_type();

   int      set_dep_strength(int the_strength);
   int      get_dep_strength(void);

   int      set_dep_dex(int the_dexterity);
   int      get_dep_dex(void);

   int      copy_weapon(Weapon *copy_from);
   Weapon *operator = (Weapon *copy_from);
   int      read_weapon_attrib(FILE *read_file, ErrLog *error_log);
   virtual  int get_mem_size();
   virtual  int get_mem_size_dynamic();

   int swing(Individual *attacker, Individual *target, Merger **proj_return);

 private:

   Weapon();

   Strings weapon_class;
   int     damage;

   hands   wield_type;

   int dep_strength;
   int dep_dexterity;

};

#endif

