/**********************************************************************
 ** Port class: This class handles a listening port, creating it and
 **             providing methods to poll it. Win32 version.
 **
 **   
 ** Reviewed through: 
 **    
 **
 ** Copyright (C) 2000 George Noel (Slate)
 **
 **   This program is free software; you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as
 **   published by the Free Software Foundation; either version 2 of the 
 **   License, or any later version. 
 **
 **   This program is distributed in the hope that it will be useful, but 
 **   WITHOUT ANY WARRANTY; without even the implied warranty of 
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 **   General Public License for more details. 
 ** 
 **   You should have received a copy of the GNU General Public License 
 **   along with this program (in the docs dir); if not, write to the Free
 **   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 **
 **********************************************************************/

#ifndef PORT_C
#define PORT_C

#include "config.h"
#include "sysdep.h"
#include "strings.h"
#include "mudobject.h"
#include "individual.h"
#include "player.h"
#include "winport.h"
#include "mud.h"
#include "global.h"

#include "utils.h"

#include "winconnection.h"


/***********************************************************************
 ** check_socket - checks the listening socket for data, and if it finds
 **                any it handles it
 **
 ** Paramters: None
 **
 ** Returns:  1 if successful
 **          -1 if an error
 **
 ***********************************************************************/

int Port::check_socket(/*Timing *tmp_timer*/)
{
/*   struct timeval timeout, null_time;
   long   elapsed = 0;
   int    v;  */          /* holds result of select */

   


   /* check the socket for data */

   		
/*   if ((v = select (list_sock + 1, &input_set, &output_set, 
                                               &exc_set, &null_time)) < 0)
   {
      perror("select, port");
      return -1;
   }
*/
   /* get time left in cycle for sleep */
/*   timeout.tv_sec = 0;
   if ((tmp_timer != NULL) && ((elapsed = tmp_timer->cycle_elapsed()) < 
                                  ((long) (1000000/the_config.pollspersec)))) 
      timeout.tv_usec = (1000000/the_config.pollspersec) - elapsed;
   else
   {
      if (tmp_timer != NULL)
      {
         mainstruct->increment_lagged_cycle();
      }
      timeout.tv_usec = 0;
   }


#if defined( AIME_WIN32 )
   Sleep( timeout.tv_usec / 1000 );
   
#else
   if (select(0, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, &timeout) < 0) {
      perror("Select sleep, port");
      return -1;
   }
#endif // AIME_WIN32


   if( tmp_timer )
      tmp_timer->set_cycle();
*/
   /* if we find an exception */
/*   if (FD_ISSET (list_sock, &exc_set))
   {
      printf("Exception pending with listening socket\n");
      v--;
   }
*/




   /* if we find a connection, create a new player */
/*      if (list_sock.m_hSocket == the_config.gameport)
      {
         AfxMessageBox("Accepting player");
         mainstruct->add_player();
      }
      else if (port == the_config.buildport)
      {
         AfxMessageBox("Accepting builder");

		 mainstruct->add_builder();
      }
   } */

   return 1;
}


/***********************************************************************
 ** get_serv_hostname - returns the server hostname string
 **
 ** Paramters: the_str - the string to put the hostname into
 **
 ** Returns: pointer to the_str with hostname loaded
 **
 ***********************************************************************/

char *Port::get_serv_hostname(void) {
   return serv_hostname.str_show();
}



/***********************************************************************
 ** connect -  Opens the listening socket and starts it listening. It
 ** (private)  places the socket in the Mud class attribute list_sock
 **            and you can poll for socket data by calling check_socket
 **
 ** Parameters: the_port - the port number to open this to
 **             quiet_mode - display output or not
 **
 ** Returns: 1  if successful
 **          -1 if socket create error
 **          -2 if gethostname error
 **          -3 if gethostbyname error
 **          -5 if listen error
 **          -6 if fcntl error
 **
 ***********************************************************************/

int Port::connect(unsigned short int the_port, bool quiet_mode)
{
   char           tmp_serv[MAXHOSTNAMELEN];
   Strings        holder;

#ifndef WIN32
   if (!quiet_mode)
      printf("Setting up listening socket.\n");
#endif

   if (!list_sock.Create(the_port))
   {
		return -1;
   }
   list_sock.port_num = the_port;

   if (!list_sock.Listen())
   {
	   return -5;	  
   }

   /* get the hostname of the server */
   if (gethostname (tmp_serv, MAXHOSTNAMELEN - 1) != 0) {
      perror("gethostname");
      return -1;
   }
   serv_hostname = tmp_serv;

   /* try to get the IP address of the server from the hostname */

   h = gethostbyname(serv_hostname.str_show());
   if (h == NULL) {
      holder.sprintf("gethostbyname host: %s", serv_hostname.str_show());
      perror(holder.str_show());
      return -2;
   }
   if (!quiet_mode)
      sysmessage("Socket configured and listening at port %d%s", list_sock.port_num, NEWLINE);

   valid = 1;

   return 1;
}

/***********************************************************************
 ** is_valid - tells if the listening port is still valid
 **
 ** Paramters: None
 **
 ** Returns: 1 if valid
 **          0 if not valid
 **
 ***********************************************************************/

int Port::is_valid() {
   return valid;
}


/***********************************************************************
 ** get_socket - gets the listening socket
 **
 ** Paramters: None
 **
 ** Returns: the listening socket
 **
 ***********************************************************************/

int Port::get_socket() {
   return 0;
}


/***********************************************************************
 ** Port (constructor) - creates and opens a listening port
 **
 ** Parameters: the_port - the port to open the listening port up to
 **             quiet_mode - display output or not
 **
 ** Returns: Nothing
 **
 ***********************************************************************/
   
Port::Port(unsigned short int the_port, bool quiet_mode)
{
   if (connect(the_port, quiet_mode) <= 0)
      valid = 0;
   else
      valid = 1;


	sin = NULL;
}   


/***********************************************************************
 ** ~Port (destructor) - closes the port and cleans it up
 **
 ** Parameters: None
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

Port::~Port()
{
//   printf("Disconnecting socket\n");
   list_sock.Close();

//   printf("Socket disconnected\n");
   return;
}


int Port::accept_conn(Connection *new_conn, MudObject *the_user)
{
	 if (!list_sock.Accept(*(new_conn->get_socket())))
	 {
	    new_conn->set_invalid();
		return -1;
	 }

	 return new_conn->accept_conn(the_user);
}


#endif
